@if ($blogs->isNotEmpty())
    <!--===============Blogs==============-->
  <section class="py-5 blogs">
    <div class="container py-5">
      <div class="text-center mb-5" data-aos="fade-down" data-aos-duration="800">
        <div class="header-text">
          <h2 class="fw-bold fs-1">
            <span class="transparent-text"> {{ __('website.our_blogs') }} </span>
          </h2>
        </div>
      </div>
      <div class="row g-4 ">
        @foreach ($blogs as $blog)
        <!-- Article 1 -->
        <div class="col-md-6 col-xl-4 wow fadeInUp" data-wow-delay="0.1s">
          <div class="card border-0 shadow-sm h-100 rounded-4 blog-simple-card">
              <a href="{{ $blog->link }}">
              <img src="{{ $blog->image_path }}" class="card-img-top rounded-top-4"
                alt="{{ $blog->name }}" />
              <div class="card-body text-start">
                <h5 class="fw-bold mb-2">
                  {{ $blog->name }}
                </h5>
                <p class="mb-3 text-secondary small">
                  {{ $blog->short_desc }}
                </p>
                <a href="{{ $blog->link }}" class="text-primary fw-semibold small">{{ __('website.more_blogs') }} <i
                    class="fas fa-arrow-right ms-1"></i></a>
              </div>
            </a>
          </div>
        </div>
        @endforeach
        <!-- Article 2 -->
      </div>
    </div>
  </section>
    <!--===============Blogs==============-->
@endif
