<x-dashboard.layout :title="__('dashboard.products')">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">{{ __('dashboard.products') }}</h4>

                    <div class="page-title-right d-flex align-items-center">
                        <x-dashboard.partials.action-buttons createUrl="{{ route('dashboard.products.create') }}" />

                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ __('dashboard.products') }}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Table -->
        <div class="row">
            <div class="col-12">
                <div class="dashboard-table-container">
                    <div class="card-header">
                        <h4>{{ __('dashboard.products') }}</h4>
                    </div>
                    <div class="card-body">
                        <table id="datatable-buttons" class="table-enhanced table-bordered dt-responsive nowrap w-100">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 50px;">
                                        <div class="checkbox-enhanced">
                                            <input type="checkbox" id="checkAll" class="form-check-input">
                                            <span class="checkmark"></span>
                                        </div>
                                    </th>
                                    <th>{{ __('dashboard.id') }}</th>
                                    <th>{{ __('dashboard.name_en') }}</th>
                                    <th>{{ __('dashboard.name_ar') }}</th>
                                    <th>{{ __('dashboard.image') }}</th>
                                    <th>{{ __('dashboard.parent') }}</th>
                                    <th>{{ __('dashboard.status') }}</th>
                                    <th>{{ __('dashboard.actions') }}</th>
                                </tr>
                            </thead>


                            <tbody>
                                @foreach ($products as $product)
                                    <tr>
                                        <td class="text-center">
                                            <div class="checkbox-enhanced">
                                                <input type="checkbox" class="check-inputs form-check-input"
                                                    value="{{ $product->id }}">
                                                <span class="checkmark"></span>
                                            </div>
                                        </td>
                                        <td>{{ $product->id }}</td>
                                        <td>
                                            <a href="{{ route('dashboard.products.edit', $product->id) }}">
                                                {{ $product->name_en }}
                                            </a>
                                        </td>
                                        <td>
                                            <a href="{{ route('dashboard.products.edit', $product->id) }}">
                                                {{ $product->name_ar }}
                                            </a>
                                        </td>
                                        <td>
                                            <a href="{{ route('dashboard.products.edit', $product->id) }}">
                                                <img src="{{ $product->image_path }}" width="70">
                                            </a>
                                        </td>
                                        <td>{{ $product->parent?->name }}</td>
                                        <td>
                                            @if ($product->status == 1)
                                                <span class="status-badge active">{{ __('dashboard.yes') }}</span>
                                            @else
                                                <span class="status-badge inactive">{{ __('dashboard.no') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="action-buttons">
                                                <a href="{{ route('dashboard.products.edit', $product->id) }}"
                                                    class="btn-action edit" title="{{ __('dashboard.edit') }}">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('dashboard.products.destroy', $product->id) }}"
                                                    method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn-action delete"
                                                        title="{{ __('dashboard.delete') }}"
                                                        onclick="return confirm('{{ __('dashboard.confirm_delete') }}')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- end cardaa -->
            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div>
    @push('scripts')
        <x-dashboard.partials.datatable />
        <script>
            var segment = 'products';
            var url = @json(url('dashboard/products'));

            $(document).ready(function() {
                // تهيئة الجدول
                var table = initializeDataTable('#datatable-buttons');

                // تهيئة الـ checkboxes المحسنة مع تأخير
                setTimeout(function() {
                    initializeEnhancedCheckboxes();
                }, 1000);

                // إعادة تهيئة الـ checkboxes عند تغيير الجدول
                table.on('draw', function() {
                    setTimeout(function() {
                        initializeEnhancedCheckboxes();
                    }, 100);
                });

                // إعادة تهيئة الجدول بعد الحذف
                $(document).on('recordDeleted', function() {
                    table = initializeDataTable('#datatable-buttons');
                    setTimeout(function() {
                        initializeEnhancedCheckboxes();
                    }, 500);
                });
            });
        </script>

        <!-- Additional Checkbox Fix -->
        <script>
            $(document).ready(function() {
                // إصلاح إضافي للـ checkboxes
                function fixCheckboxes() {
                    // إزالة event handlers السابقة
                    $(document).off('change', '#checkAll');
                    $(document).off('change', '.check-inputs');

                    // إضافة event handlers جديدة
                    $(document).on('change', '#checkAll', function() {
                        var isChecked = $(this).is(':checked');
                        $('.check-inputs').prop('checked', isChecked);
                        updateCheckboxAppearance();
                    });

                    $(document).on('change', '.check-inputs', function() {
                        var totalCheckboxes = $('.check-inputs').length;
                        var checkedCheckboxes = $('.check-inputs:checked').length;
                        $('#checkAll').prop('checked', totalCheckboxes === checkedCheckboxes);
                        updateCheckboxAppearance();
                    });

                    function updateCheckboxAppearance() {
                        $('.check-inputs:checked').closest('.checkbox-enhanced').addClass('checked');
                        $('.check-inputs:not(:checked)').closest('.checkbox-enhanced').removeClass('checked');

                        if ($('#checkAll').is(':checked')) {
                            $('#checkAll').closest('.checkbox-enhanced').addClass('checked');
                        } else {
                            $('#checkAll').closest('.checkbox-enhanced').removeClass('checked');
                        }
                    }

                    // تطبيق المظهر الأولي
                    updateCheckboxAppearance();
                }

                // تشغيل الإصلاح مع تأخير
                setTimeout(fixCheckboxes, 1500);

                // إعادة تشغيل الإصلاح عند تغيير الجدول
                $(document).on('draw.dt', function() {
                    setTimeout(fixCheckboxes, 100);
                });

                // اختبار الـ checkboxes
                console.log('Checkboxes initialized');
                console.log('Total checkboxes found:', $('.check-inputs').length);
                console.log('Select All checkbox found:', $('#checkAll').length);

                // حل بسيط للـ checkboxes
                $(document).on('click', '.checkbox-enhanced', function(e) {
                    e.preventDefault();
                    var checkbox = $(this).find('input[type="checkbox"]');
                    var isChecked = checkbox.is(':checked');
                    checkbox.prop('checked', !isChecked);

                    if (checkbox.attr('id') === 'checkAll') {
                        $('.check-inputs').prop('checked', !isChecked);
                    } else {
                        var totalCheckboxes = $('.check-inputs').length;
                        var checkedCheckboxes = $('.check-inputs:checked').length;
                        $('#checkAll').prop('checked', totalCheckboxes === checkedCheckboxes);
                    }

                    // تحديث المظهر
                    setTimeout(function() {
                        $('.check-inputs:checked').closest('.checkbox-enhanced').addClass('checked');
                        $('.check-inputs:not(:checked)').closest('.checkbox-enhanced').removeClass(
                            'checked');

                        if ($('#checkAll').is(':checked')) {
                            $('#checkAll').closest('.checkbox-enhanced').addClass('checked');
                        } else {
                            $('#checkAll').closest('.checkbox-enhanced').removeClass('checked');
                        }
                    }, 10);
                });
            });
        </script>

        <x-dashboard.partials.delete-btn />
    @endpush

    @section('script')
    @endSection
</x-dashboard.layout>
