<x-dashboard.layout :title="__('dashboard.edit') . $product->name">

    @section('style')
        <style>
            .sortable-container {
                cursor: move;
            }

            .sortable-container.sortable-ghost {
                opacity: 0.5;
            }

            .sortable-container.sortable-chosen {
                background-color: #f8f9fa;
                border: 2px dashed #007bff;
            }

            .drag-handle {
                cursor: move;
                position: absolute;
                top: 5px;
                right: 5px;
                background: rgba(0, 0, 0, 0.5);
                color: white;
                padding: 2px 6px;
                border-radius: 3px;
                font-size: 12px;
            }
        </style>
    @endsection

    <!-- Enhanced Page Header -->
    <div class="enhanced-page-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h4>{{ __('dashboard.edit') . $product->name }}</h4>
            </div>
            <div class="col-md-4">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a
                                href="{{ route('dashboard.products.index') }}">{{ __('dashboard.products') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('dashboard.edit') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
    <!-- End Enhanced Page Header -->


    <!-- Enhanced Form Container -->
    <div class="enhanced-form-container">

        <form action="{{ route('dashboard.products.update', [$product->id]) }}" method="POST"
            enctype="multipart/form-data" id="product-update-form">
            @csrf
            @method('PATCH')

            <!-- Basic Information Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-info-circle me-2"></i>{{ __('dashboard.basic_information') }}</h4>
                <div class="row">

                    <div class="form-group col-md-4 enhanced-form-group">
                        <label>{{ __('dashboard.name_en') }}</label>
                        <input class="form-control" name="name_en" type="text" value="{{ $product->name_en }}"
                            placeholder="{{ __('dashboard.name_en') }}">
                    </div>

                    <div class="form-group col-md-4 enhanced-form-group">
                        <label>{{ __('dashboard.name_ar') }}</label>
                        <input class="form-control" name="name_ar" type="text" value="{{ $product->name_ar }}"
                            placeholder="{{ __('dashboard.name_ar') }}">
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label>{{ __('dashboard.order') }}</label>
                        <input class="form-control" name="order" type="number" value="{{ $product->order }}"
                            placeholder="{{ __('dashboard.order') }}">
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label for="parent">{{ __('dashboard.parent') }}</label>
                        <select class="form-control select2" name="parent_id">
                            <option value="">{{ __('dashboard.no_parent') }}</option>
                            @foreach ($products as $productItem)
                                <option value="{{ $productItem->id }}"
                                    {{ old('parent_id', $product->parent_id) == $productItem->id ? 'selected' : '' }}>
                                    {{ $productItem->name }}
                                </option>
                            @endforeach
                        </select>
                        @if ($product->parent)
                            <div class="mt-2 text-info">
                                <small>{{ __('dashboard.current_parent') }}:
                                    <b>{{ $product->parent->name }}</b></small>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Images Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-images me-2"></i>{{ __('dashboard.images') }}</h4>
                <div class="row">
                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.image') }} (225px * 225px max 1mb)</label>
                        <div class="enhanced-file-input">
                            <input type="file" name="image" accept="image/*">
                            <label for="image" class="file-input-label">
                                <i class="fas fa-upload"></i>
                                {{ __('dashboard.choose_file') }}
                            </label>
                        </div>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.image_preview') }}</label>
                        <div class="enhanced-image-preview">
                            @if ($product->image_path)
                                <img src="{{ $product->image_path }}" alt="{{ $product->name }}">
                                <div class="image-overlay">
                                    <i class="fas fa-eye"></i>
                                </div>
                            @else
                                <div class="enhanced-no-image">
                                    <i class="fas fa-image"></i>
                                    <span>{{ __('dashboard.no_image_available') }}</span>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label>{{ __('dashboard.alt_image') }}</label>
                        <input class="form-control" name="alt_image" type="text"
                            placeholder="{{ __('dashboard.alt_image') }}" value="{{ $product->alt_image }}">
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.icon') }} (50px * 50px max 1mb)</label>
                        <div class="enhanced-file-input">
                            <input type="file" name="icon" accept="image/*" id="icon-input">
                            <label for="icon-input" class="file-input-label">
                                <i class="fas fa-upload"></i>
                                {{ __('dashboard.choose_file') }}
                            </label>
                        </div>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.icon_preview') }}</label>
                        <div class="enhanced-image-preview">
                            @if ($product->icon_path)
                                <img src="{{ $product->icon_path }}" alt="{{ $product->name }}">
                                <div class="image-overlay">
                                    <i class="fas fa-eye"></i>
                                </div>
                            @else
                                <div class="enhanced-no-image">
                                    <i class="fas fa-image"></i>
                                    <span>{{ __('dashboard.no_image_available') }}</span>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label>{{ __('dashboard.alt_icon') }}</label>
                        <input class="form-control" name="alt_icon" type="text"
                            placeholder="{{ __('dashboard.alt_icon') }}" value="{{ $product->alt_icon }}">
                    </div>
                </div>
            </div>



            <!-- Descriptions Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-align-left me-2"></i>{{ __('dashboard.descriptions') }}</h4>
                <div class="row">
                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.short_desc_en') }}</label>
                        <textarea class="form-control" name="short_desc_en" type="text" placeholder="{{ __('dashboard.short_desc_en') }}">{!! $product->short_desc_en !!}</textarea>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.short_desc_ar') }}</label>
                        <textarea class="form-control" name="short_desc_ar" type="text"
                            placeholder="{{ __('dashboard.short_desc_ar') }}">{!! $product->short_desc_ar !!}</textarea>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.long_desc_en') }}</label>
                        <textarea class="form-control" id="myeditorinstance" name="long_desc_en" type="text"
                            placeholder="{{ __('dashboard.long_desc_en') }}">{!! $product->long_desc_en !!}</textarea>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label>{{ __('dashboard.long_desc_ar') }}</label>
                        <textarea class="form-control" id="myeditorinstance" name="long_desc_ar" type="text"
                            placeholder="{{ __('dashboard.long_desc_ar') }}">{!! $product->long_desc_ar !!}</textarea>
                    </div>
                </div>
            </div>
            <!-- product Details Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-product-diagram me-2"></i>{{ __('dashboard.product_details') }}</h4>
                <div class="row">
                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.clients_en') }}</label>
                        <input class="form-control" name="clients_en" type="text"
                            value="{{ $product->clients_en }}" placeholder="{{ __('dashboard.clients_en') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.location_en') }}</label>
                        <input class="form-control" name="location_en" type="text"
                            value="{{ $product->location_en }}" placeholder="{{ __('dashboard.location_en') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.category_en') }}</label>
                        <input class="form-control" name="category_en" type="text"
                            value="{{ $product->category_en }}" placeholder="{{ __('dashboard.category_en') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.service_en') }}</label>
                        <input class="form-control" name="service_en" type="text"
                            value="{{ $product->service_en }}" placeholder="{{ __('dashboard.service_en') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.clients_ar') }}</label>
                        <input class="form-control" name="clients_ar" type="text"
                            value="{{ $product->clients_ar }}" placeholder="{{ __('dashboard.clients_ar') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.location_ar') }}</label>
                        <input class="form-control" name="location_ar" type="text"
                            value="{{ $product->location_ar }}" placeholder="{{ __('dashboard.location_ar') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.category_ar') }}</label>
                        <input class="form-control" name="category_ar" type="text"
                            value="{{ $product->category_ar }}" placeholder="{{ __('dashboard.category_ar') }}">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label>{{ __('dashboard.service_ar') }}</label>
                        <input class="form-control" name="service_ar" type="text"
                            value="{{ $product->service_ar }}" placeholder="{{ __('dashboard.service_ar') }}">
                    </div>

                    <div class="form-group col-md-4 enhanced-form-group">
                        <label>{{ __('dashboard.date') }}</label>
                        <input class="form-control" name="date" type="date" value="{{ $product->date }}"
                            placeholder="{{ __('dashboard.date') }}">
                    </div>
                </div>
            </div>
            <!-- Category Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-tags me-2"></i>{{ __('home.edit_category') }}</h4>
                <div class="row align-items-center mb-3">
                    <div class="col-md-10">
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            {{ __('home.changing category will change specifications values') }}
                        </div>
                    </div>
                    <div class="col-md-2 text-end">
                        <a type="button" class="btn enhanced-btn enhanced-btn-primary" data-bs-toggle="modal"
                            data-bs-target="#Modal1">
                            <i class="fas fa-edit me-2"></i>{{ __('dashboard.edit') }}
                        </a>
                    </div>
                    <div class="col-md-12 mt-2">
                        <div class="form-group enhanced-form-group">
                            <select class="form-control select2" name="category_id" id="category_id">
                                <option value="{{ $product->category_id }}">
                                    {{ $product->category?->{'name_' . app()->getLocale()} ?? '' }}
                                </option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group col-md-12 enhanced-form-group">
                    <label for="product_images">{{ __('dashboard.product_images') }}</label>
                    <div class="enhanced-file-input">
                        <input type="file" name="product_images[]" multiple accept="image/*"
                            id="product-images-input">
                        <label for="product-images-input" class="file-input-label">
                            <i class="fas fa-upload"></i>
                            {{ __('dashboard.choose_files') }}
                        </label>
                    </div>
                </div>
            </div>
            <!-- Image Gallery Section -->
            @if (!empty($product->images) && $product->images->count() > 0)
                <div class="enhanced-gallery-container">
                    <h4><i class="fas fa-images me-2"></i>{{ __('dashboard.product_images') }}</h4>
                    <div id="delete_selected_images_form">
                        <div class="d-flex flex-wrap mb-3 align-items-center gap-2">
                            <button type="button" id="select_all_btn" class="btn enhanced-btn enhanced-btn-primary">
                                <i class="fas fa-check-square me-2"></i>{{ __('dashboard.select_all') }}
                            </button>
                            <button type="button" id="delete_selected_btn"
                                class="btn enhanced-btn enhanced-btn-danger">
                                <i class="fas fa-trash me-2"></i>{{ __('dashboard.delete_selected') }}
                            </button>
                            <a href='#' data-id="{{ $product->id }}"
                                class='delete_all_img btn enhanced-btn enhanced-btn-danger'>
                                <i class="fas fa-trash-alt me-2"></i>{{ __('dashboard.delete_all') }}
                            </a>
                            <button type="button" id="save_order_btn" class="btn enhanced-btn enhanced-btn-success">
                                <i class="fas fa-save me-2"></i>{{ __('dashboard.save_order') }}
                            </button>
                        </div>
                        <div class="col-md-12 mt-3">
                            <div class="row mb-0" id="sortable-images">
                                @foreach ($product->images as $key => $image)
                                    <div class="col-md-3 col-sm-6 mb-3 sortable-container"
                                        data-id="{{ $image->id }}">
                                        <div class="enhanced-gallery-item">
                                            <div class="drag-handle">⋮⋮</div>
                                            <img class="card-img-top" src="{{ $image->image_url }}"
                                                style="height: 200px; object-fit: cover;">
                                            <div class="card-body text-center">
                                                <input type="checkbox" name="selected_images[]"
                                                    value="{{ $image->id }}" class="select_image_checkbox mb-2">
                                                <button type="button" data-image="{{ $image->id }}"
                                                    class="delete_img_btn btn enhanced-btn enhanced-btn-danger btn-sm">
                                                    <i class="fas fa-trash me-1"></i>{{ trans('dashboard.delete') }}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endif
            <!-- Status Controls Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-toggle-on me-2"></i>{{ __('dashboard.status_controls') }}</h4>
                <div class="row">
                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.publish/unpublish') }}</h5>
                            <input type="checkbox" id="switch1" switch="none" value="1" name="status"
                                @checked(old('status', $product->status)) />
                            <label for="switch1" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.show_in_home') }}</h5>
                            <input type="checkbox" id="switch2" switch="none" value="1" name="show_in_home"
                                @checked(old('show_in_home', $product->show_in_home)) />
                            <label for="switch2" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.show_in_header') }}</h5>
                            <input type="checkbox" id="switch3" switch="none" value="1"
                                name="show_in_header" @checked(old('show_in_header', $product->show_in_header)) />
                            <label for="switch3" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.show_in_footer') }}</h5>
                            <input type="checkbox" id="switch4" switch="none" value="1"
                                name="show_in_footer" @checked(old('show_in_footer', $product->show_in_footer)) />
                            <label for="switch4" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>
                </div>
            </div>


            <!-- SEO Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-search me-2"></i>{{ __('dashboard.seo') }}</h4>
                <div class="row">
                    <div class="form-group col-md-2 enhanced-form-group">
                        <label>{{ __('dashboard.slug_en') }}</label>
                        <input type="text" autocomplete="off" class="form-control"
                            placeholder="{{ __('dashboard.slug_en') }}" name="slug_en"
                            value="{{ $product->slug_en }}">
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.meta_title_en') }}</label>
                        <textarea class="form-control" name="meta_title_en" placeholder="{{ __('dashboard.meta_title_en') }}">{!! $product->meta_title_en !!}</textarea>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.meta_desc_en') }}</label>
                        <textarea class="form-control" name="meta_desc_en" placeholder="{{ __('dashboard.meta_desc_en') }}">{!! $product->meta_desc_en !!}</textarea>
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label>{{ __('dashboard.slug_ar') }}</label>
                        <input type="text" autocomplete="off" class="form-control"
                            placeholder="{{ __('dashboard.slug_ar') }}" name="slug_ar"
                            value="{{ $product->slug_ar }}">
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.meta_title_ar') }}</label>
                        <textarea class="form-control" name="meta_title_ar" placeholder="{{ __('dashboard.meta_title_ar') }}">{!! $product->meta_title_ar !!}</textarea>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label>{{ __('dashboard.meta_desc_ar') }}</label>
                        <textarea class="form-control" name="meta_desc_ar" placeholder="{{ __('dashboard.meta_desc_ar') }}">{!! $product->meta_desc_ar !!}</textarea>
                    </div>

                    <div class="form-group col-md-12">
                        <div class="enhanced-switch-container">
                            <h5>{{ __('dashboard.meta_robots') }} (index)</h5>
                            <input type="checkbox" id="switch5" switch="none" value="1" name="index"
                                @checked(old('index', $product->index)) />
                            <label for="switch5" data-on-label="{{ __('dashboard.yes') }}"
                                data-off-label="{{ __('dashboard.no') }}"></label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Enhanced Action Buttons -->
            <div class="enhanced-action-buttons text-center">
                <button type="submit" class="btn enhanced-btn enhanced-btn-success">
                    <i class="fas fa-save me-2"></i>{{ __('dashboard.update') }}
                </button>
                <a href="{{ route('dashboard.products.index') }}" class="btn enhanced-btn enhanced-btn-danger">
                    <i class="fas fa-times me-2"></i>{{ __('dashboard.cancel') }}
                </a>
            </div>
    </div>
    </form>
    </div>
    </div>
    </div>
    </div>
    <!-- End Row -->

    <!-- modal1 -->
    <div class="modal fade text-left" id="Modal1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header justify-content-between">
                    <h3 class="modal-title" id="myModalLabel34">{{ trans('home.edit_category') }}</h3>
                    <a type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                        X
                    </a>
                </div>
                <form action="{{ route('dashboard.dashboard.products.changeCategory', $product->id) }}"
                    method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">

                            <div class="form-group col-md-12">
                                <select class="form-control" data-trigger name="category_id" id="category" required>
                                    <option></option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}"
                                            {{ $product->category_id == $category->id ? 'selected' : '' }}>
                                            {{ app()->getLocale() == 'en' ? $category->name_en : $category->name_ar }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-md-12 mt-3">
                                <button type="submit" class="btn btn-primary w-md"> {{ trans('home.save') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @section('script')
        <script>
            var token = "{{ csrf_token() }}";
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            // Enhanced file input preview
            $(document).on('change', 'input[name="image"]', function() {
                const file = this.files[0];
                const preview = $(this).closest('.enhanced-form-group').next().find('img');
                const noImageDiv = $(this).closest('.enhanced-form-group').next().find('.enhanced-no-image');

                console.log('Image file selected:', file);
                console.log('Preview element:', preview.length);
                console.log('No image div:', noImageDiv.length);

                if (file) {
                    console.log('File details:', {
                        name: file.name,
                        size: file.size,
                        type: file.type
                    });

                    // Validate file type
                    if (!file.type.startsWith('image/')) {
                        alert('يرجى اختيار ملف صورة صالح');
                        return;
                    }

                    // Validate file size (1MB max)
                    if (file.size > 1024 * 1024) {
                        alert('حجم الملف كبير جداً. الحد الأقصى 1MB');
                        return;
                    }

                    const reader = new FileReader();
                    reader.onload = function(e) {
                        console.log('File loaded successfully');
                        preview.attr('src', e.target.result);
                        preview.show();
                        if (noImageDiv.length) {
                            noImageDiv.hide();
                        }
                    };
                    reader.readAsDataURL(file);
                }
            });

            $(document).on('change', 'input[name="icon"]', function() {
                const file = this.files[0];
                const preview = $(this).closest('.enhanced-form-group').next().find('img');
                const noImageDiv = $(this).closest('.enhanced-form-group').next().find('.enhanced-no-image');

                console.log('Icon file selected:', file);
                console.log('Preview element:', preview.length);
                console.log('No image div:', noImageDiv.length);

                if (file) {
                    console.log('Icon file details:', {
                        name: file.name,
                        size: file.size,
                        type: file.type
                    });

                    // Validate file type
                    if (!file.type.startsWith('image/')) {
                        alert('يرجى اختيار ملف صورة صالح');
                        return;
                    }

                    // Validate file size (1MB max)
                    if (file.size > 1024 * 1024) {
                        alert('حجم الملف كبير جداً. الحد الأقصى 1MB');
                        return;
                    }

                    const reader = new FileReader();
                    reader.onload = function(e) {
                        console.log('Icon file loaded successfully');
                        preview.attr('src', e.target.result);
                        preview.show();
                        if (noImageDiv.length) {
                            noImageDiv.hide();
                        }
                    };
                    reader.readAsDataURL(file);
                }
            });

            // Debug function to check if elements exist
            console.log('Image input exists:', $('input[name="image"]').length);
            console.log('Icon input exists:', $('input[name="icon"]').length);

            // Handle product images multiple upload
            $(document).on('change', 'input[name="product_images[]"]', function() {
                const files = this.files;
                console.log('product images selected:', files.length);
                console.log('product images files:', files);

                if (files.length > 0) {
                    alert('تم اختيار ' + files.length + ' صورة بنجاح');
                }
            });

            // Initialize file inputs when page loads
            $(document).ready(function() {
                console.log('Page loaded, initializing file inputs...');

                // Check if file inputs exist
                if ($('input[name="image"]').length) {
                    console.log('Image input found');
                } else {
                    console.log('Image input NOT found');
                }

                if ($('input[name="icon"]').length) {
                    console.log('Icon input found');
                } else {
                    console.log('Icon input NOT found');
                }

                // Force show existing images
                $('.enhanced-image-preview img').each(function() {
                    if ($(this).attr('src') && $(this).attr('src') !== '') {
                        $(this).show();
                        $(this).closest('.enhanced-image-preview').find('.enhanced-no-image').hide();
                    }
                });

                // Add click handler to file input labels
                $('.file-input-label').on('click', function() {
                    const input = $(this).prev('input[type="file"]');
                    if (input.length) {
                        input.trigger('click');
                    }
                });
            });

            // Enhanced form validation
            $('form').on('submit', function(e) {
                console.log('Form submitting...');
                console.log('Form data:', new FormData(this));

                let isValid = true;

                $('.enhanced-form-group input[required], .enhanced-form-group textarea[required], .enhanced-form-group select[required]')
                    .each(function() {
                        if (!$(this).val()) {
                            $(this).addClass('is-invalid');
                            isValid = false;
                        } else {
                            $(this).removeClass('is-invalid').addClass('is-valid');
                        }
                    });

                // Check if files are selected
                const imageFile = $('input[name="image"]')[0].files[0];
                const iconFile = $('input[name="icon"]')[0].files[0];
                const productImages = $('input[name="product_images[]"]')[0].files;

                console.log('Image file:', imageFile);
                console.log('Icon file:', iconFile);
                console.log('product images:', productImages);

                if (!isValid) {
                    e.preventDefault();
                    alert('{{ __('dashboard.please_fill_required_fields') }}');
                }
            });
        </script>
        <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
        <script>
            // Select all/unselect all button
            var allSelected = false;
            $('#select_all_btn').on('click', function() {
                allSelected = !allSelected;
                $('input.select_image_checkbox').prop('checked', allSelected);
                $(this).text(allSelected ? '{{ __('dashboard.unselect_all') }}' :
                    '{{ __('dashboard.select_all') }}');
            });
        </script>
        <script>
            // Delete selected images
            $('#delete_selected_btn').on('click', function(e) {
                e.preventDefault();
                var selected = [];
                $('input.select_image_checkbox:checked').each(function() {
                    selected.push($(this).val());
                });
                if (selected.length === 0) {
                    alert('Please select the images to delete');
                    return;
                }
                if (confirm('Are you sure you want to delete the selected images?')) {
                    $.ajax({
                        url: "{{ route('dashboard.dashboard.products.deleteSelectedImages') }}",
                        method: 'POST',
                        data: {
                            image_ids: selected,
                            _token: token
                        },
                        success: function(data) {
                            if (data.success) {
                                location.reload();
                            } else {
                                alert(data.message || 'Error');
                            }
                        },
                        error: function(xhr) {
                            alert(xhr.responseJSON?.message || 'Error');
                        }
                    });
                }
            });
        </script>
        <script>
            $('.delete_all_img').on('click', function(e) {
                e.preventDefault();
                var productId = $(this).data('id');
                if (confirm('{{ __('dashboard.confirm_delete_all_images') }}')) {
                    $.ajax({
                        url: "{{ route('dashboard.dashboard.products.deleteAllImages') }}",
                        method: 'POST',
                        data: {
                            product_id: productId,
                            _token: token
                        },
                        success: function(data) {
                            if (data.success) {
                                location.reload();
                            } else {
                                alert(data.message || 'حدث خطأ أثناء الحذف');
                            }
                        },
                        error: function(xhr) {
                            alert(xhr.responseJSON?.message || 'حدث خطأ أثناء الحذف');
                        }
                    });
                }
            });
        </script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>

        <script type="text/javascript">
            Dropzone.autoDiscover = false;

            $("div.upload_images").dropzone({
                addRemoveLinks: true,
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg.webp",
                maxFilesize: 3, // MB
                url: "{{ route('dashboard.dashboard.products.uploadImages') }}",

                init: function() {
                    this.on("sending", function(file, xhr, formData) {
                        formData.append("productId", "{{ $product->id }}");
                    });
                },

                params: {
                    _token: token,
                    type: 'product_image',
                },

                removedfile: function(file) {
                    var fileName = file.name;
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': token
                        }
                    });
                    $.ajax({
                        type: 'POST',
                        url: "{{ route('dashboard.dashboard.products.removeUploadImages') }}", // Use route instead of URL::to
                        data: {
                            type: 'product_image',
                            name: fileName,
                            request: 'delete'
                        },
                        success: function(data) {
                            console.log('success: ' + data);
                        }
                    });
                    var _ref;
                    return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) :
                        void 0;
                }
            });

            Dropzone.options.myAwesomeDropzone = {
                paramName: "file",
                maxFilesize: 3, // MB
                accept: function(file, done) {
                    done();
                }
            };

            $('.delete_img_btn').on('click', function() {
                var image = $(this).data('image');
                var productId = "{{ $product->id }}";
                var btn = $(this);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': token
                    }
                });
                $.ajax({
                    url: "{{ route('dashboard.dashboard.products.deleteImage') }}",
                    method: 'POST',
                    data: {
                        image: image,
                        productId: productId
                    },
                    success: function(data) {
                        location.href = "{{ route('dashboard.products.edit', $product->id) }}";
                    }
                });
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            // Enable drag & drop for images
            var sortableImages = document.getElementById('sortable-images');
            if (sortableImages) {
                new Sortable(sortableImages, {
                    animation: 150,
                    ghostClass: 'sortable-ghost',
                    chosenClass: 'sortable-chosen',
                    handle: '.drag-handle',
                    onEnd: function(evt) {
                        console.log('Order changed');
                    }
                });
            }

            // حفظ الترتيب الجديد
            $('#save_order_btn').on('click', function() {
                var imageIds = [];
                $('#sortable-images .sortable-container').each(function() {
                    imageIds.push($(this).data('id'));
                });

                if (imageIds.length === 0) {
                    alert('No images to save order');
                    return;
                }

                $.ajax({
                    url: "{{ route('dashboard.dashboard.products.reorderImages') }}",
                    method: 'POST',
                    data: {
                        image_ids: imageIds,
                        _token: token
                    },
                    success: function(data) {
                        if (data.success) {
                            alert(data.message || 'Order saved successfully');
                        } else {
                            alert(data.message || 'Error saving order');
                        }
                    },
                    error: function(xhr) {
                        alert(xhr.responseJSON?.message || 'Error saving order');
                    }
                });
            });
        </script>
        <script>
            $('input[type="file"][name="product_images[]"]').on('change', function(e) {
                var maxSize = 1 * 1024 * 1024; // 1MB
                for (let i = 0; i < this.files.length; i++) {
                    if (this.files[i].size > maxSize) {
                        alert('Maximum image size is 1MB');
                        this.value = ""; // Clear the field
                        break;
                    }
                }
            });
        </script>
    @endsection

</x-dashboard.layout>
