<?php

namespace App\Services\Dashboard;

use App\Models\Album;
use Illuminate\Support\Facades\DB;

class AlbumService
{
    public function store($request, $data)
    {
        DB::beginTransaction();
        try {
            $album = Album::create($data);
            DB::commit();
            return $album;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function update($request, $data, $album)
    {
        DB::beginTransaction();
        try {
            $album->update($data);
            DB::commit();
            return $album;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function delete($selectedIds)
    {
        $albums = Album::whereIn('id', $selectedIds)->get();
        DB::beginTransaction();
        try {
            foreach ($albums as $album) {
                $album->delete();
            }
            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }
}
