<?php

namespace App\Models;

use App\Traits\HasLanguage;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
class Category extends Model
{
    /** @use HasFactory<\Database\Factories\CategoryFactory> */
    use HasFactory , HasLanguage;
    protected $fillable = [
        'name_en', 'name_ar', 'order', 'parent_id', 'image', 'icon', 'alt_image', 'alt_icon',
        'short_desc_en', 'short_desc_ar', 'long_desc_en', 'long_desc_ar',
        'status', 'show_in_home', 'show_in_header', 'show_in_footer',
        'meta_title_en', 'meta_title_ar', 'meta_desc_en', 'meta_desc_ar', 'index'
    ];

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function projects()
    {
        return $this->hasMany(Project::class);
    } 

    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    public function images()
    {
        return $this->hasMany(CategoryImage::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    public function scopeHome($query)
    {
        return $query->where('show_in_home', 1);
    }
    public function getLinkAttribute()
    {
        return  LaravelLocalization::LocalizeUrl('products/'.$this->{'slug_' . $this->lang});
    }
    public function getNameAttribute()
    {
        return $this->{'name_'.$this->lang};
    }
} 