<?php

namespace App\Http\Middleware;

use App\Models\Redirect;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class RedirectsMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $path = '/' . ltrim($request->getPathInfo(), '/');
        $fullUrl = $request->fullUrl();

        $redirects = Cache::remember('redirects.map', 300, function () {
            return Redirect::where('is_active', true)->get();
        });

        $match = $redirects->first(function ($r) use ($path, $fullUrl) {
            return $r->source === $path || $r->source === $fullUrl;
        });

        if ($match) {
            $status = (int) $match->status_code;
            if ($status === 410) {
                abort(410);
            }
            if (!empty($match->target)) {
                return redirect()->away($match->target, in_array($status, [301, 302], true) ? $status : 301);
            }
        }

        return $next($request);
    }
}


