<script src="<?php echo e(asset('assets/dashboard/tinymce/tinymce.min.js')); ?>" referrerpolicy="origin"></script>
<script>
    // Initialize TinyMCE for all textareas with class="editor-textarea"
    document.addEventListener('DOMContentLoaded', function() {
        // Find all textareas with class="editor-textarea"
        const textareas = document.querySelectorAll('textarea.editor-textarea');

        textareas.forEach(function(textarea, index) {
            // Create unique ID for each textarea if it doesn't have one
            if (!textarea.id) {
                const uniqueId = 'tinymce_editor_' + index + '_' + textarea.name.replace(
                    /[^a-zA-Z0-9]/g, '_');
                textarea.id = uniqueId;
            }

            // Initialize TinyMCE for this specific textarea
            tinymce.init({
                selector: '#' + textarea.id,
                license_key: 'gpl', // Use GPL license for open source
                height: 300,
                menubar: false,
                plugins: [
                    'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
                    'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
                    'insertdatetime', 'media', 'table', 'help', 'wordcount',
                    'directionality'
                ],
                toolbar: 'undo redo | blocks | bold italic forecolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help | code',
                content_style: 'body { font-family: -apple-system, BlinkMacSystemFont, San Francisco, Segoe UI, Roboto, Helvetica Neue, sans-serif; font-size: 14px; }',
                setup: function(editor) {
                    editor.on('init', function() {
                        console.log('TinyMCE initialized for:', textarea.name,
                            'with ID:', textarea.id);
                    });
                }
            });
        });
    });
</script>
<?php /**PATH /home/webtest3/public_html/mepicom-new/resources/views/components/dashboard/tinymce-config.blade.php ENDPATH**/ ?>