@if (!empty($metatags))
    {{-- Basic Meta Tags --}}
    <meta charset="{{ $metatags['charset'] ?? 'utf-8' }}">
    <meta name="viewport" content="{{ $metatags['viewport'] ?? 'width=device-width, initial-scale=1.0' }}">
    <meta http-equiv="Content-Language" content="{{ $metatags['language'] ?? 'en' }}">
    <meta name="robots" content="{{ $metatags['robots'] ?? 'index, follow' }}">
    <meta name="description" content="{{ $metatags['description'] ?? '' }}">
    @if (!empty($metatags['keywords']))
        <meta name="keywords" content="{{ $metatags['keywords'] }}">
    @endif
    <meta name="author" content="{{ $metatags['author'] ?? '' }}">
    <title>{{ $metatags['title'] ?? config('settings.site_name') }}</title>

    @if (!empty($metatags['time']))
        <meta name="time" content="{{ $metatags['time'] }}">
    @endif


    {{-- Canonical --}}
    @if (!empty($metatags['canonical']))
        <link rel="canonical" href="{{ $metatags['canonical'] }}">
    @endif

    {{-- Favicon --}}
    <link rel="icon" href="{{ \App\Helper\Path::FavIcon() }}" type="image/x-icon">
    <link rel="apple-touch-icon" href="{{ \App\Helper\Path::FavIcon() }}">

    {{-- Open Graph --}}
    <meta property="og:title" content="{{ $metatags['og_title'] ?? ($metatags['title'] ?? '') }}">
    <meta property="og:description" content="{{ $metatags['og_description'] ?? ($metatags['description'] ?? '') }}">
    <meta property="og:url" content="{{ $metatags['og_url'] ?? url()->current() }}">
    <meta property="og:image" content="{{ $metatags['og_image'] ?? asset('images/default-og.jpg') }}">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="{{ $metatags['og_title'] ?? ($metatags['title'] ?? '') }}">
    <meta property="og:type" content="{{ $metatags['og_type'] ?? 'website' }}">
    <meta property="og:site_name" content="{{ $metatags['og_site_name'] ?? config('settings.site_name') }}">
    <meta property="og:locale" content="{{ $metatags['og_locale'] ?? app()->getLocale() }}">

    {{-- Twitter --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $metatags['twitter_title'] ?? ($metatags['title'] ?? '') }}">
    <meta name="twitter:description"
        content="{{ $metatags['twitter_description'] ?? ($metatags['description'] ?? '') }}">
    <meta name="twitter:image" content="{{ $metatags['twitter_image'] ?? asset('images/default-og.jpg') }}">
    @if (!empty($metatags['twitter_site']))
        <meta name="twitter:site" content="{{ $metatags['twitter_site'] }}">
    @endif
    @if (!empty($metatags['twitter_creator']))
        <meta name="twitter:creator" content="{{ $metatags['twitter_creator'] }}">
    @endif

    {{-- Performance --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="dns-prefetch" href="//www.google-analytics.com">
    <link rel="dns-prefetch" href="//www.googletagmanager.com">
@endif

{{-- Schema JSON-LD --}}
@if (!empty($schema))
    <script type="application/ld+json">
{!! json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@else
    {{-- Default WebPage Schema (safe encoding) --}}
    <script type="application/ld+json">
{!! json_encode([
    '@context' => 'https://schema.org',
    '@type' => 'WebPage',
    'name' => $metatags['title'] ?? config('settings.site_name'),
    'url' => $metatags['canonical'] ?? url()->current(),
    'description' => $metatags['description'] ?? ''
], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- FAQ Schema --}}
@if (!empty($faq_schema))
    <script type="application/ld+json">
    {!! json_encode($faq_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- Breadcrumb Schema --}}
@if (!empty($breadcrumb_schema))
    <script type="application/ld+json">
    {!! json_encode($breadcrumb_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- Google Tag Manager --}}
@if (config('settings.google_tag_manager_id'))
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', '{{ config('settings.google_tag_manager_id') }}');
    </script>
@endif

{{-- Google Analytics --}}
@if (config('settings.google_analytics_id'))
    <script async src="https://www.googletagmanager.com/gtag/js?id={{ config('settings.google_analytics_id') }}"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', '{{ config('settings.google_analytics_id') }}');
    </script>
@endif

{{-- Security --}}
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
<meta http-equiv="Strict-Transport-Security" content="max-age=31536000; includeSubDomains; preload">
<!-- Google reCAPTCHA -->
