@if ($services->isNotEmpty())
    <!--==========================Services==========================-->
    <section class="py-5 services">
        <div class="pb-5 container">
            <div class="text-center mb-5" data-aos="fade-down" data-aos-duration="800">
                <div class="header-text">
                    <h2 class="fw-bold fs-1">{{ __('website.our_services') }}</h2>
                </div>
            </div>
            <div class="row g-5">
                @foreach ($services as $service)
                    <div class="col-xl-4 col-md-6 wow fadeInUp  py-5" data-wow-duration="1.5s">
                        <a href="{{ $service->link }}" class="custom-services position-relative px-2">
                            <img src="{{ $service->image_path }}" class="img-fluid shadow-lg rounded-4 object-fit-cover"
                                alt="" />

                            <div class="content-service bg-white shadow rounded-3 px-3 py-2">
                                <h2 class="fw-medium mb-0 py-2 lh-lg">{{ $service->name }}</h2>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
            <div class="text-center mt-5">
                <a href="{{ Path::AppUrl('services') }}" class="btn btn-warning py-3 px-4 wow fadeInUp"
                        data-wow-delay="0.4s">{{ __('website.more_services') }}
                    <i class="fas fa-arrow-right ms-2"></i></a>
            </div>
        </div>
    </section>
    <!--==========================Services==========================-->
@endif
