<x-dashboard.layout :title="__('dashboard.edit') . $project->name">

    @section('style')
        <style>
            .sortable-container {
                cursor: move;
            }

            .sortable-container.sortable-ghost {
                opacity: 0.5;
            }

            .sortable-container.sortable-chosen {
                background-color: #f8f9fa;
                border: 2px dashed #007bff;
            }

            .drag-handle {
                cursor: move;
                position: absolute;
                top: 5px;
                right: 5px;
                background: rgba(0, 0, 0, 0.5);
                color: white;
                padding: 2px 6px;
                border-radius: 3px;
                font-size: 12px;
            }
        </style>
    @endsection

    <!-- Page Header -->
    <x-dashboard.partials.page-header :header="__('dashboard.edit') . $project->name" :label_url="route('dashboard.projects.index')" :label="__('dashboard.projects')" />
    <!-- End Page Header -->


    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card ">
                <div class="card-header d-flex justify-content-between">
                    <h4 class="card-title pt-3">{{ __('dashboard.edit') . $project->name }}</h4>
                </div>

                <div class="card-body">

                    <form action="{{ route('dashboard.projects.update', [$project->id]) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PATCH')
                        <div class="row">

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.name_en') }}</label>
                                <input class="form-control" name="name_en" type="text"
                                    value="{{ $project->name_en }}" placeholder="{{ __('dashboard.name_en') }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.name_ar') }}</label>
                                <input class="form-control" name="name_ar" type="text"
                                    value="{{ $project->name_ar }}" placeholder="{{ __('dashboard.name_ar') }}">
                            </div>


                            <div class="form-group col-md-2">
                                <label class="">{{ __('dashboard.order') }}</label>
                                <input class="form-control" name="order" type="number" value="{{ $project->order }}"
                                    placeholder="{{ __('dashboard.order') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="parent">{{ __('dashboard.parent') }}</label>
                                <select class="form-control select2" name="parent_id">
                                    <option value="{{ $project->parent_id ?? null }}">
                                        {{ $project->parent?->name ?? __('dashboard.select_parent') }}</option>

                                    @foreach ($projects as $projectItem)
                                        <option @selected(old('parent_id') == $projectItem->id) value="{{ $projectItem->id }}">
                                            {{ $projectItem->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class=" form-group  col-md-6">
                                <label>{{ __('dashboard.image') }} (225px * 225px max 1mb)</label>
                                <input type="file" class="form-control" name="image" accept="image/*">
                            </div>

                            <div class=" form-group  col-md-2">
                                <label for="">{{ __('dashboard.image') }}</label>
                                <img src="{{ $project->image_path }}" width="250">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_image') }}</label>
                                <input class="form-control" name="alt_image" type="text"
                                    placeholder="{{ __('dashboard.alt_image') }}" value="{{ $project->alt_image }}">
                            </div>

                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.icon') }} (50px * 50px max 1mb)</label>
                                <input type="file" class="form-control" name="icon" accept="image/*">

                            </div>

                            <div class=" form-group  col-md-2">
                                <label for="">{{ __('dashboard.icon') }}</label>
                                <img src="{{ $project->icon_path }}" width="250">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_icon') }}</label>
                                <input class="form-control" name="alt_icon" type="text"
                                    placeholder="{{ __('dashboard.alt_icon') }}" value="{{ $project->alt_icon }}">
                            </div>



                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.short_desc_en') }}</label>
                                <textarea class="form-control" name="short_desc_en" type="text" placeholder="{{ __('dashboard.short_desc_en') }}">{!! $project->short_desc_en !!}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.short_desc_ar') }}</label>
                                <textarea class="form-control" name="short_desc_ar" type="text" placeholder="{{ __('dashboard.short_desc_ar') }}">{!! $project->short_desc_ar !!}</textarea>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.long_desc_en') }}</label>
                                <textarea class="form-control" id="myeditorinstance" name="long_desc_en" type="text"
                                    placeholder="{{ __('dashboard.long_desc_en') }}">{!! $project->long_desc_en !!}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ __('dashboard.long_desc_ar') }}</label>
                                <textarea class="form-control" id="myeditorinstance" name="long_desc_ar" type="text"
                                    placeholder="{{ __('dashboard.long_desc_ar') }}">{!! $project->long_desc_ar !!}</textarea>
                            </div>
                            <br>
                            <hr>
                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.clients_en') }}</label>
                                <input class="form-control" name="clients_en" type="text"
                                    value="{{ $project->clients_en }}"
                                    placeholder="{{ __('dashboard.clients_en') }}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.location_en') }}</label>
                                <input class="form-control" name="location_en" type="text"
                                    value="{{ $project->location_en }}"
                                    placeholder="{{ __('dashboard.location_en') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.category_en') }}</label>
                                <input class="form-control" name="category_en" type="text"
                                    value="{{ $project->category_en }}"
                                    placeholder="{{ __('dashboard.category_en') }}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.service_en') }}</label>
                                <input class="form-control" name="service_en" type="text"
                                    value="{{ $project->service_en }}"
                                    placeholder="{{ __('dashboard.service_en') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.clients_ar') }}</label>
                                <input class="form-control" name="clients_ar" type="text"
                                    value="{{ $project->clients_ar }}"
                                    placeholder="{{ __('dashboard.clients_ar') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.location_ar') }}</label>
                                <input class="form-control" name="location_ar" type="text"
                                    value="{{ $project->location_ar }}"
                                    placeholder="{{ __('dashboard.location_ar') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.category_ar') }}</label>
                                <input class="form-control" name="category_ar" type="text"
                                    value="{{ $project->category_ar }}"
                                    placeholder="{{ __('dashboard.category_ar') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ __('dashboard.service_ar') }}</label>
                                <input class="form-control" name="service_ar" type="text"
                                    value="{{ $project->service_ar }}"
                                    placeholder="{{ __('dashboard.service_ar') }}">
                            </div>

                            <div class="form-group col-md-4"></div>
                            <label class="">{{ __('dashboard.date') }}</label>
                            <input class="form-control" name="date" type="date" value="{{ $project->date }}"
                                placeholder="{{ __('dashboard.date') }}">
                        </div>
                        <br>
                        <hr>
                        <div class="row align-items-center mb-3">
                            <div class="col-md-10">
                                <h6 class="card-title mb-1">
                                    {{ __('home.edit_category') }}
                                    <span class="badge badge-warning">
                                        {{ __('home.changing category will change specifications values') }}
                                    </span>
                                </h6>
                            </div>
                            <div class="col-md-2 text-end">
                                <a type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#Modal1">
                                    <i class="fas fa-edit" style="color:black"></i>
                                </a>
                            </div>
                            <div class="col-md-12 mt-2">
                                <div class="form-group">
                                    <select class="form-control select2" name="category_id" id="category_id">
                                        <option value="{{ $project->category_id }}">
                                            {{ $project->category?->{'name_' . app()->getLocale()} ?? '' }}
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group col-md-12">
                            <hr>
                            <label for="project_images">{{ __('dashboard.project_images') }}</label>
                            <input type="file" class="form-control" name="project_images[]" multiple
                                accept="image/*">
                        </div>
                        <br>
                        <hr>
                        <br>
                        @if (!empty($project->images) && $project->images->count() > 0)
                            <div id="delete_selected_images_form">
                                <div class="d-flex flex-wrap mb-2 align-items-center">
                                    <button type="button" id="select_all_btn" class="btn btn-secondary mr-2"
                                        style="margin: 5px;">{{ __('dashboard.select_all') }}</button>
                                    <button type="button" id="delete_selected_btn" class="btn btn-danger mr-2"
                                        style="margin: 5px;">{{ __('dashboard.delete_selected') }}</button>
                                    <a href='#' data-id="{{ $project->id }}"
                                        class='delete_all_img btn btn-danger'
                                        style="margin: 5px;">{{ __('dashboard.delete_all') }}</a>
                                    <button type="button" id="save_order_btn" class="btn btn-success mr-2"
                                        style="margin: 5px;">{{ __('dashboard.save_order') }}</button>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <div class="row mb-0" id="sortable-images">
                                        @foreach ($project->images as $key => $image)
                                    <div class="col-md-3 col-sm-6 mb-3 sortable-container" data-id="{{ $image->id }}">
                                        <div class="card">
                                            <div class="position-relative">
                                                <div class="drag-handle">⋮⋮</div>
                                                <img class="card-img-top" src="{{ $image->image_url }}"
                                                    style="height: 200px; object-fit: cover;">
                                            </div>
                                            <div class="card-body text-center">
                                                <input type="checkbox" name="selected_images[]"
                                                    value="{{ $image->id }}" class="select_image_checkbox mb-2">
                                                <button type="button" data-image="{{ $image->id }}"
                                                    class="delete_img_btn btn btn-danger btn-sm">
                                                    {{ trans('dashboard.delete') }}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="row mt-3">
                            <div class="form-group col-md-3">
                                <div class="d-flex flex-wrap gap-2">
                                    <h5 class="font-size-14 mb-3">{{ __('dashboard.publish/unpublish') }} </h5>
                                    <input type="checkbox" id="switch1" switch="none" value="1"
                                        name="status" @checked(old('status', $project->status)) />
                                    <label for="switch1" data-on-label="{{ __('dashboard.yes') }}"
                                        data-off-label="{{ __('dashboard.no') }}"></label>
                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <div class="d-flex flex-wrap gap-2">
                                    <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_home') }}</h5>
                                    <input type="checkbox" id="switch2" switch="none" value="1"
                                        name="show_in_home" @checked(old('show_in_home', $project->show_in_home)) />
                                    <label for="switch2" data-on-label="{{ __('dashboard.yes') }}"
                                        data-off-label="{{ __('dashboard.no') }}"></label>
                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <div class="d-flex flex-wrap gap-2">
                                    <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_header') }} </h5>
                                    <input type="checkbox" id="switch3" switch="none" value="1"
                                        name="show_in_header" @checked(old('show_in_header', $project->show_in_header)) />
                                    <label for="switch3" data-on-label="{{ __('dashboard.yes') }}"
                                        data-off-label="{{ __('dashboard.no') }}"></label>
                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <div class="d-flex flex-wrap gap-2">
                                    <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_footer') }} </h5>
                                    <input type="checkbox" id="switch4" switch="none" value="1"
                                        name="show_in_footer" @checked(old('show_in_footer', $project->show_in_footer)) />
                                    <label for="switch4" data-on-label="{{ __('dashboard.yes') }}"
                                        data-off-label="{{ __('dashboard.no') }}"></label>
                                </div>
                            </div>

                        </div>


                        <div class="col-12">
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <hr>
                                    <h4 class="card-title">{{ __('dashboard.seo') }}</h4>
                                </div>
                                <div class="form-group col-md-2">
                                    <label for="name_ar">{{ __('dashboard.slug_en') }}</label>
                                    <input type="text" autocomplete="off" class="form-control"
                                        placeholder="{{ __('dashboard.slug_en') }}" name="slug_en"
                                        value="{{ $project->slug_en }}">
                                </div>

                                <div class="form-group col-md-5">
                                    <label> {{ __('dashboard.meta_title_en') }}</label>
                                    <textarea class="form-control" name="meta_title_en" placeholder="{{ __('dashboard.meta_title_en') }}"> {!! $project->meta_title_en !!}</textarea>
                                </div>

                                <div class="form-group col-md-5">
                                    <label for="meta_desc"> {{ __('dashboard.meta_desc_en') }}</label>
                                    <textarea class="form-control" name="meta_desc_en" placeholder="{{ __('dashboard.meta_desc_en') }}"> {!! $project->meta_desc_en !!}</textarea>
                                </div>

                                <div class="form-group col-md-12">
                                    <hr>

                                </div>

                                <div class="form-group col-md-2">
                                    <label>{{ __('dashboard.slug_ar') }}</label>
                                    <input type="text" autocomplete="off" class="form-control"
                                        placeholder="{{ __('dashboard.slug_ar') }}" name="slug_ar"
                                        value="{{ $project->slug_ar }}">
                                </div>

                                <div class="form-group col-md-5">
                                    <label> {{ __('dashboard.meta_title_ar') }}</label>
                                    <textarea class="form-control" name="meta_title_ar" placeholder="{!! __('dashboard.meta_title_ar') !!}">{{ $project->meta_title_ar }}</textarea>
                                </div>

                                <div class="form-group col-md-5">
                                    <label> {{ __('dashboard.meta_desc_ar') }}</label>
                                    <textarea class="form-control" name="meta_desc_ar" placeholder="{!! __('dashboard.meta_desc') !!}">{!! $project->meta_desc_ar !!}</textarea>
                                </div>


                                <div class="d-flex flex-wrap gap-2">
                                    <h5 class="font-size-14 mb-3">{{ __('dashboard.meta_robots') }} (index)</h5>
                                    <input type="checkbox" id="switch5" switch="none" value="1"
                                        name="index" @checked(old('index', $project->index)) />
                                    <label for="switch5" data-on-label="{{ __('dashboard.yes') }}"
                                        data-off-label="{{ __('dashboard.no') }}"></label>

                                </div>
                            </div>
                        </div>
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                {{ __('dashboard.update') }} </button>
                            <a href="{{ route('dashboard.projects.index') }}"><button type="button"
                                    class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                    {{ __('dashboard.cancel') }}</button></a>
                        </div>
                </div>
                </form>
            </div>
        </div>
    </div>
    </div>
    <!-- End Row -->

    <!-- modal1 -->
    <div class="modal fade text-left" id="Modal1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header justify-content-between">
                    <h3 class="modal-title" id="myModalLabel34">{{ trans('home.edit_category') }}</h3>
                    <a type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                        X
                    </a>
                </div>
                <form action="{{ route('dashboard.dashboard.projects.changeCategory', $project->id) }}"
                    method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">

                            <div class="form-group col-md-12">
                                <select class="form-control" data-trigger name="category_id" id="category" required>
                                    <option></option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}"
                                            {{ $project->category_id == $category->id ? 'selected' : '' }}>
                                            {{ app()->getLocale() == 'en' ? $category->name_en : $category->name_ar }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-md-12 mt-3">
                                <button type="submit" class="btn btn-primary w-md"> {{ trans('home.save') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @section('script')
        <script>
            var token = "{{ csrf_token() }}";
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });
        </script>
        <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
        <script>
            // Select all/unselect all button
            var allSelected = false;
            $('#select_all_btn').on('click', function() {
                allSelected = !allSelected;
                $('input.select_image_checkbox').prop('checked', allSelected);
                $(this).text(allSelected ? '{{ __('dashboard.unselect_all') }}' :
                    '{{ __('dashboard.select_all') }}');
            });
        </script>
        <script>
            // Delete selected images
            $('#delete_selected_btn').on('click', function(e) {
                e.preventDefault();
                var selected = [];
                $('input.select_image_checkbox:checked').each(function() {
                    selected.push($(this).val());
                });
                if (selected.length === 0) {
                    alert('Please select the images to delete');
                    return;
                }
                if (confirm('Are you sure you want to delete the selected images?')) {
                    $.ajax({
                        url: "{{ route('dashboard.dashboard.projects.deleteSelectedImages') }}",
                        method: 'POST',
                        data: {
                            image_ids: selected,
                            _token: token
                        },
                        success: function(data) {
                            if (data.success) {
                                location.reload();
                            } else {
                                alert(data.message || 'Error');
                            }
                        },
                        error: function(xhr) {
                            alert(xhr.responseJSON?.message || 'Error');
                        }
                    });
                }
            });
        </script>
        <script>
            $('.delete_all_img').on('click', function(e) {
                e.preventDefault();
                var projectId = $(this).data('id');
                if (confirm('{{ __('dashboard.confirm_delete_all_images') }}')) {
                    $.ajax({
                        url: "{{ route('dashboard.dashboard.projects.deleteAllImages') }}",
                        method: 'POST',
                        data: {
                            project_id: projectId,
                            _token: token
                        },
                        success: function(data) {
                            if (data.success) {
                                location.reload();
                            } else {
                                alert(data.message || 'حدث خطأ أثناء الحذف');
                            }
                        },
                        error: function(xhr) {
                            alert(xhr.responseJSON?.message || 'حدث خطأ أثناء الحذف');
                        }
                    });
                }
            });
        </script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>

        <script type="text/javascript">
            Dropzone.autoDiscover = false;

            $("div.upload_images").dropzone({
                addRemoveLinks: true,
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg.webp",
                maxFilesize: 3, // MB
                url: "{{ route('dashboard.dashboard.projects.uploadImages') }}",

                init: function() {
                    this.on("sending", function(file, xhr, formData) {
                        formData.append("projectId", "{{ $project->id }}");
                    });
                },

                params: {
                    _token: token,
                    type: 'product_image',
                },

                removedfile: function(file) {
                    var fileName = file.name;
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': token
                        }
                    });
                    $.ajax({
                        type: 'POST',
                        url: "{{ route('dashboard.dashboard.projects.removeUploadImages') }}", // Use route instead of URL::to
                        data: {
                            type: 'project_image',
                            name: fileName,
                            request: 'delete'
                        },
                        success: function(data) {
                            console.log('success: ' + data);
                        }
                    });
                    var _ref;
                    return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) :
                        void 0;
                }
            });

            Dropzone.options.myAwesomeDropzone = {
                paramName: "file",
                maxFilesize: 3, // MB
                accept: function(file, done) {
                    done();
                }
            };

            $('.delete_img_btn').on('click', function() {
                var image = $(this).data('image');
                var projectId = "{{ $project->id }}";
                var btn = $(this);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': token
                    }
                });
                $.ajax({
                    url: "{{ route('dashboard.dashboard.projects.deleteImage') }}",
                    method: 'POST',
                    data: {
                        image: image,
                        projectId: projectId
                    },
                    success: function(data) {
                        location.href = "{{ route('dashboard.projects.edit', $project->id) }}";
                    }
                });
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            // Enable drag & drop for images
            var sortableImages = document.getElementById('sortable-images');
            if (sortableImages) {
                new Sortable(sortableImages, {
                    animation: 150,
                    ghostClass: 'sortable-ghost',
                    chosenClass: 'sortable-chosen',
                    handle: '.drag-handle',
                    onEnd: function(evt) {
                        console.log('Order changed');
                    }
                });
            }

            // حفظ الترتيب الجديد
            $('#save_order_btn').on('click', function() {
                var imageIds = [];
                $('#sortable-images .sortable-container').each(function() {
                    imageIds.push($(this).data('id'));
                });

                if (imageIds.length === 0) {
                    alert('No images to save order');
                    return;
                }

                $.ajax({
                    url: "{{ route('dashboard.dashboard.projects.reorderImages') }}",
                    method: 'POST',
                    data: {
                        image_ids: imageIds,
                        _token: token
                    },
                    success: function(data) {
                        if (data.success) {
                            alert(data.message || 'Order saved successfully');
                        } else {
                            alert(data.message || 'Error saving order');
                        }
                    },
                    error: function(xhr) {
                        alert(xhr.responseJSON?.message || 'Error saving order');
                    }
                });
            });
        </script>
        <script>
            $('input[type="file"][name="project_images[]"]').on('change', function(e) {
                var maxSize = 1 * 1024 * 1024; // 1MB
                for (let i = 0; i < this.files.length; i++) {
                    if (this.files[i].size > maxSize) {
                        alert('Maximum image size is 1MB');
                        this.value = ""; // Clear the field
                        break;
                    }
                }
            });
        </script>
    @endsection

</x-dashboard.layout>
