<?php

namespace Database\Seeders;

use App\Models\Product;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'name_ar' => 'منتج 1',
                'name_en' => 'Product 1',
                'short_desc_ar' => 'منتج 1 سريع وآمن',
                'short_desc_en' => 'Fast and secure product 1',
                'long_desc_ar' => 'منتج 1 موثوق وسريع مع دعم فني على مدار الساعة',
                'long_desc_en' => 'Reliable and fast product 1 with 24/7 support',
                'status' => 1,
                'show_in_home'=> 1,
                'show_in_header'=> 1,
                'slug_ar' => 'منتج-1',
                'slug_en' => 'product-1',
                'meta_title_ar' => 'منتج 1',
                'meta_title_en' => 'Product 1',
                'meta_desc_ar' => 'منتج 1 موثوق وسريع مع دعم فني على مدار الساعة',
                'meta_desc_en' => 'Reliable and fast product 1 with 24/7 support',
                'index' => 1,
                'category_id' => 1,
                'alt_image' => 'منتج 1',
                'alt_icon' => 'منتج 1',
                'order' => 1,
                'clients_ar' => 'منتج 1',
                'location_ar' => 'منتج 1',
                'clients_en' => 'Product 1',
                'location_en' => 'Location 1',
                'category_en' => 'Category 1',
                'service_en' => 'Service 1',
                'date' => '2025-01-01',
                'category_ar' => 'منتج 1',
                'service_ar' => 'منتج 1',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name_ar' => 'منتج 2',
                'name_en' => 'Product 2',
                'short_desc_ar' => 'منتج 2 سريع وآمن',
                'short_desc_en' => 'Fast and secure product 2',
                'long_desc_ar' => 'منتج 2 موثوق وسريع مع دعم فني على مدار الساعة',
                'long_desc_en' => 'Reliable and fast product 2 with 24/7 support',
                'status' => 1,
                'show_in_home'=> 1,
                'show_in_header'=> 1,
                'slug_ar' => 'منتج-2',
                'slug_en' => 'product-2',
                'meta_title_ar' => 'منتج 2',
                'meta_title_en' => 'Product 2',
                'meta_desc_ar' => 'منتج 2 موثوق وسريع مع دعم فني على مدار الساعة',
                'meta_desc_en' => 'Reliable and fast product 2 with 24/7 support',
                'index' => 1,
                'category_id' => 2,
                'alt_image' => 'منتج 2',
                'alt_icon' => 'منتج 2',
                'order' => 2,
                'clients_ar' => 'منتج 2',
                'location_ar' => 'منتج 2',
                'clients_en' => 'Product 2',
                'location_en' => 'Location 2',
                'category_en' => 'Category 2',
                'service_en' => 'Service 2',
                'date' => '2025-01-02',
                'category_ar' => 'منتج 2',
                'service_ar' => 'منتج 2',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name_ar' => 'منتج 3',
                'name_en' => 'Product 3',
                'short_desc_ar' => 'منتج 3 سريع وآمن',
                'short_desc_en' => 'Fast and secure product 3',
                'long_desc_ar' => 'منتج 3 موثوق وسريع مع دعم فني على مدار الساعة',
                'long_desc_en' => 'Reliable and fast product 3 with 24/7 support',
                'status' => 1,
                'show_in_home'=> 1,
                'show_in_header'=> 1,
                'slug_ar' => 'منتج-3',
                'slug_en' => 'product-3',
                'meta_title_ar' => 'منتج 3',
                'meta_title_en' => 'Product 3',
                'meta_desc_ar' => 'منتج 3 موثوق وسريع مع دعم فني على مدار الساعة',
                'meta_desc_en' => 'Reliable and fast product 3 with 24/7 support',
                'index' => 1,
                'category_id' => 3,
                'alt_image' => 'منتج 3',
                'alt_icon' => 'منتج 3',
                'order' => 3,
                'clients_ar' => 'منتج 3',
                'location_ar' => 'منتج 3',
                'clients_en' => 'Product 3',
                'location_en' => 'Location 3',
                'category_en' => 'Category 3',
                'service_en' => 'Service 3',
                'date' => '2025-01-03',
                'category_ar' => 'منتج 3',
                'service_ar' => 'منتج 3',
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ];
        foreach ($data as $item) {
            Product::create($item);
        }
    }
}
