<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\View\Composers\SeoComposer;
use App\Models\Phone;
use App\Models\Dashboard\Menu;
use App\Models\SiteAddress;
use App\Models\Section;
use App\Models\Service;
use App\Models\Project;
use App\Models\Product;
use App\Models\Blog;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Illuminate\Support\Facades\Route;

class ViewComposerServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        // SEO Composer for main layout pages and website components
        View::composer(['layouts.app', 'Website.*', 'components.website.*'], SeoComposer::class);

        View::composer('components.website.partials._header', function ($view) {
            $phone = Phone::active()->where('order', 1)->first();
            $menus = Menu::active()->orderBy('order', 'asc')->get();
            $site_addresses = SiteAddress::active()->orderBy('order', 'asc')->get();

            $socialMediaLinks = [
                'whatsapp' => config('settings.site_whatsapp') ? 'https://wa.me/' . ltrim(config('settings.site_whatsapp'), '+') : '#',
                'facebook' => config('settings.site_facebook') ?? '#',
                'twitter' => config('settings.site_twitter') ?? '#',
                'instagram' => config('settings.site_instagram') ?? '#',
                'youtube' => config('settings.site_youtube') ?? '#',
                'linkedin' => config('settings.site_linkedin') ?? '#',
                'tiktok' => config('settings.site_tiktok') ?? '#',
                'snapchat' => config('settings.site_snapchat') ?? '#',
                'pinterest' => config('settings.site_pinterest') ?? '#',
                'telegram' => config('settings.site_telegram') ?? '#',
            ];

            // Language switcher logic
            $currentLocale = app()->getLocale();
            $altLangLink = null;
            $route = Route::current();
            $routeParameters = $route ? $route->parameters() : [];
            $targetLang = $currentLocale === 'ar' ? 'en' : 'ar';
            $currentPath = $route ? $route->uri() : '';

            if ($route) {
                $slug = null;
                $model = null;
                $targetPath = null;

                // تحديد المعلمة والنموذج المناسب
                if (str_contains($currentPath, 'services')) {
                    $slug = $routeParameters['slug'] ?? null;
                    $model = Service::class;
                    $targetPath = 'services';
                } elseif (str_contains($currentPath, 'projects')) {
                    $item = $routeParameters['project'] ?? null;
                    if ($item instanceof Project) {
                        $slug = $item->{'slug_' . $currentLocale};
                    } else {
                        $slug = $item;
                    }
                    $model = Project::class;
                    $targetPath = 'projects';
                } elseif (str_contains($currentPath, 'products')) {
                    $item = $routeParameters['product'] ?? null;
                    if ($item instanceof Product) {
                        $slug = $item->{'slug_' . $currentLocale};
                    } else {
                        $slug = $item;
                    }
                    $model = Product::class;
                    $targetPath = 'products';
                } elseif (str_contains($currentPath, 'blogs')) {
                    $slug = $routeParameters['slug'] ?? null;
                    $model = Blog::class;
                    $targetPath = 'blogs';
                }

                // البحث عن العنصر وإنشاء الرابط
                if ($slug && $model && $targetPath) {
                    $item = $model::where('slug_' . $currentLocale, $slug)->first();
                    if ($item) {
                        $targetSlug = $item->{'slug_' . $targetLang};
                        if ($targetSlug) {
                            $altLangLink = LaravelLocalization::getLocalizedURL(
                                $targetLang,
                                $targetPath . '/' . $targetSlug
                            );
                        }
                    }
                }
            }
            
            // إذا لم يتم إنشاء رابط محدد، استخدم الرابط الافتراضي
            if (!$altLangLink) {
                $altLangLink = LaravelLocalization::getLocalizedURL($targetLang);
            }
            
            $view->with('headerPhone', $phone);
            $view->with('menus', $menus);
            $view->with('site_addresses', $site_addresses);
            $view->with('socialMediaLinks', $socialMediaLinks);
            $view->with('altLangLink', $altLangLink);
        });

        //Footer composer Socal Media Links & Phones & Site Addresses
        View::composer('components.website.partials._footer', function ($view) {
            $socialMediaLinks = [
                'whatsapp' => config('settings.site_whatsapp') ? 'https://wa.me/' . ltrim(config('settings.site_whatsapp'), '+') : '#',
                'facebook' => config('settings.site_facebook') ?? '#',
                'twitter' => config('settings.site_twitter') ?? '#',
                'instagram' => config('settings.site_instagram') ?? '#',
                'youtube' => config('settings.site_youtube') ?? '#',
                'linkedin' => config('settings.site_linkedin') ?? '#',
                'tiktok' => config('settings.site_tiktok') ?? '#',
                'snapchat' => config('settings.site_snapchat') ?? '#',
                'pinterest' => config('settings.site_pinterest') ?? '#',
                'telegram' => config('settings.site_telegram') ?? '#',
            ];

            $phones = Phone::active()->where('order', 1)->get();
            $site_addresses = SiteAddress::active()->orderBy('order', 'asc')->get();
            $view->with('socialMediaLinks', $socialMediaLinks);
            $view->with('phones', $phones);
            $view->with('site_addresses', $site_addresses);
        });
    }


    public function register(): void
    {
        //
    }
}