<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Http\Requests\Dashboard\Phones\StorePhoneRequest;
use App\Http\Requests\Dashboard\Phones\UpdatePhoneRequest;
use App\Models\Phone;
use Illuminate\Http\Request;

class PhoneController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $phones = Phone::latest()->paginate(10);
        return view('Dashboard.Phones.index', compact('phones'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('Dashboard.Phones.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorePhoneRequest $request)
    {
        Phone::create($request->validated());
        return redirect()->route('dashboard.phones.index')->with('success', 'تم إضافة الهاتف بنجاح');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $phone = Phone::findOrFail($id);
        return view('Dashboard.Phones.show', compact('phone'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $phone = Phone::findOrFail($id);
        return view('Dashboard.Phones.edit', compact('phone'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatePhoneRequest $request, string $id)
    {
        $phone = Phone::findOrFail($id);
        $phone->update($request->validated());
        return redirect()->route('dashboard.phones.index')->with('success', 'تم تحديث الهاتف بنجاح');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $phone = Phone::findOrFail($id);
        $phone->delete();
        return redirect()->route('dashboard.phones.index')->with('success', 'تم حذف الهاتف بنجاح');
    }
}
