<!--==========================Services==========================-->
<section class="product py-5 text-center">
    <div class="container mb-5">
        <div class="text-center mb-5" data-aos="fade-down" data-aos-duration="800">
            <div class="header-text">
                <h2 class="fw-bold fs-1">
                    <span class="transparent-text"> <?php echo e(__('dashboard.products')); ?> </span>
                </h2>
            </div>
        </div>
        <ul class="nav nav-pills nav-tabs-custom mb-5 d-flex justify-content-center flex-xxl-nowrap" id="productsTab" role="tablist">
    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?php if($loop->first): ?> active <?php endif; ?> text-nowrap" 
                id="<?php echo e($category->id); ?>-tab" 
                data-bs-toggle="tab"
                data-bs-target="#<?php echo e($category->id); ?>" 
                type="button" role="tab">
                <?php echo e($category->name); ?>

            </button>
        </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</ul>

<div class="tab-content" id="productsTabContent">
    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="tab-pane fade <?php if($loop->first): ?> show active <?php endif; ?>" 
            id="<?php echo e($category->id); ?>" 
            role="tabpanel" 
            aria-labelledby="<?php echo e($category->id); ?>-tab">
            
            <div class="row g-4">
                <?php $__currentLoopData = $category->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                        <div class="product-card">
                            <a href="<?php echo e($product->link); ?>">
                                <img src="<?php echo e($product->image_path); ?>" class="product-img shine-hover" alt="<?php echo e($product->name); ?>" />
                                <div class="product-body">
                                    <span class="product-category border border-primary text-primary text-opacity-75 px-3 py-1 rounded-2">
                                        <?php echo e($category->name); ?>

                                    </span>
                                    <h3 class="product-title pb-2">
                                        <?php echo e($product->name); ?>

                                    </h3>
                                    <p>
                                        <?php echo e($product->short_desc); ?>

                                    </p>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

        <div class="text-center mt-5">
            <a href="<?php echo e(Path::AppUrl('products')); ?>" class="btn btn-warning py-3 px-4 wow fadeInUp" data-wow-delay="0.4s"><?php echo e(__('website.more_products')); ?>

                <i class="fas fa-arrow-right ms-2"></i></a>
        </div>
    </div>
</section>

<!-- Products Section Start -->

<!--==========================Services==========================-->
<?php /**PATH /home/webtest3/public_html/mepicom-new/resources/views/Website/home-partials/products.blade.php ENDPATH**/ ?>