<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>{{ $title }}</title>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="{{ Path::FavIcon() }}" type="image/x-icon" />

    <!-- Css -->
    <x-dashboard.partials.css />

    <!--TinyMCE  script -->
    <x-dashboard.tinymce-config />

    {{-- Google Tag Manager --}}
    @if (config('settings.google_tag_manager_id'))
        <script>
            (function(w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start': new Date().getTime(),
                    event: 'gtm.js'
                });
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s),
                    dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '{{ config('settings.google_tag_manager_id') }}');
        </script>
    @endif
    {{-- End Google Tag Manager --}}

</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">

        <x-dashboard.partials.header />

        <!-- ========== Left Sidebar Start ========== -->
        <x-dashboard.partials.left-sidebar />
        <!-- Left Sidebar End -->


        <!-- Start right Content here -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    {{ $slot }}
                </div>
            </div>
        </div>

        <!-- Right Sidebar -->
        <x-dashboard.partials.right-sidebar />
        <!-- /Right-bar -->

    </div>

    <!-- JAVASCRIPT -->

    <x-dashboard.partials.script />

    @yield('script')
    @stack('scripts')

    {{-- Google Tag Manager (noscript) --}}
    @if (config('settings.google_tag_manager_id'))
        <noscript><iframe
                src="https://www.googletagmanager.com/ns.html?id={{ config('settings.google_tag_manager_id') }}"
                height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    @endif
    {{-- End Google Tag Manager (noscript) --}}
</body>

</html>
