<x-dashboard.layout title="{{ __('dashboard.phones') }}">
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('dashboard.phones') }}</h4>
                <div class="page-title-right">
                    <a href="{{ route('dashboard.phones.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> {{ __('dashboard.add_new_phone') }}
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                    <table id="datatable-buttons" class="table table-bordered dt-responsive nowrap w-100">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('dashboard.name_ar') }}</th>
                                    <th>{{ __('dashboard.name_en') }}</th>
                                    <th>{{ __('dashboard.code') }}</th>
                                    <th>{{ __('dashboard.phone_number') }}</th>
                                    <th>{{ __('dashboard.email') }}</th>
                                    <th>{{ __('dashboard.order') }}</th>
                                    <th>{{ __('dashboard.status') }}</th>
                                    <th>{{ __('dashboard.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($phones as $phone)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $phone->name_ar ?? '-' }}</td>
                                    <td>{{ $phone->name_en ?? '-' }}</td>
                                    <td>{{ $phone->code ?? '-' }}</td>
                                    <td>{{ $phone->phone }}</td>
                                    <td>{{ $phone->email ?? '-' }}</td>
                                    <td>{{ $phone->order ?? '-' }}</td>
                                    <td>
                                        @if($phone->status)
                                            <span class="badge bg-success">{{ __('dashboard.active') }}</span>
                                        @else
                                            <span class="badge bg-danger">{{ __('dashboard.inactive') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('dashboard.phones.edit', $phone->id) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('dashboard.phones.destroy', $phone->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="10" class="text-center">{{ __('dashboard.no_phones') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</x-dashboard.layout> 