<?php

namespace Database\Seeders;

use App\Models\Dashboard\Menu;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'name_en' => 'Home',
                'name_ar' => 'الرئيسية',
                'segment' => '/',
                'parent_id' => null,
                'order' => 1,
                'status' => true,
            ],
            [
                'name_en' => 'About Us',
                'name_ar' => 'من نحن',
                'segment' => '/about-us',
                'parent_id' => null,
                'order' => 2,
                'status' => true,
            ],

            [
                'name_en' => 'Our Services',
                'name_ar' => 'الخدمات',
                'segment' => '/services',
                'parent_id' => null,
                'order' => 3,
                'status' => true,
            ],
            [
                'name_en' => 'Our Products',
                'name_ar' => 'المنتجات',
                'segment' => '/products',
                'parent_id' => null,
                'order' => 4,
                'status' => true,
            ],
            [
                'name_en' => 'Our Projects',
                'name_ar' => 'المشاريع',
                'segment' => '/projects',
                'parent_id' => null,
                'order' => 5,
                'status' => true,
            ],
            [
                'name_en' => 'careers',
                'name_ar' => 'الوظائف',
                'segment' => '/careers',
                'parent_id' => null,
                'order' => 5,
                'status' => true,
            ],
            
            [
                'name_en' => 'News & Articles',
                'name_ar' => 'الأخبار والمقالات',
                'segment' => '/blogs',
                'parent_id' => null,
                'order' => 6,
                'status' => true,
            ],
            [
                'name_en' => 'Contact Us',
                'name_ar' => 'تواصل معنا',
                'segment' => '/contact-us',
                'parent_id' => null,
                'order' => 7,
                'status' => true,
            ]
        ];

        foreach ($data as $item) {
            Menu::updateOrCreate(
                ['segment' => $item['segment']],
                $item
            );
        }
    }
}