<?php

namespace App\Models\Dashboard;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasLanguage;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class Menu extends Model
{
    use HasLanguage;

    protected $table = 'menus';

    protected $fillable = ['name_en', 'name_ar', 'parent_id', 'segment', 'status', 'order', 'type'];


    public static function getSegmentSelect()
    {
        return [
            '/'          => __('dashboard.home'),
            'about-us'   => __('dashboard.about_us'),
            'hostings'   => __('dashboard.hostings'),
            'services' => __('dashboard.categories'),
            'products' => __('dashboard.products'),         
            'projects'   => __('dashboard.projects'),
            'careers' => __('dashboard.careers'),
            'blogs' => __('dashboard.blogs'),
            'contact-us' => __('dashboard.contact_us'),
        ];
    }

    public function parent()
    {
        return $this->belongsTo(Menu::class, 'parent_id');
    }

    public function getParentNameAttribute()
    {

        return $this->parent ? $this->parent->{'name_' . $this->lang} : __('dashboard.no_parent');
    }

    public function getNameAttribute()
    {
        return $this->{'name_' . $this->lang};
    }


    public function scopeActive(Builder $query): void
    {
        $query->where('status', 1);
    }

    public function getLinkAttribute()
    {

        return $this->segment ? LaravelLocalization::LocalizeUrl($this->segment) : '#';
    }
}