<?php


class TripHelper extends controller{


	


	public function GetKilometerPriceDataByKilometerNum($kilometerNum)


    {


        $KilometerData = $this->loadModel("KilometerModel")->retrieveAllData("WHERE `from_kilometer` <= ? AND `to_kilometer` >= ? AND `status` =? AND `deleted` =? ORDER BY `id` DESC",array($kilometerNum,$kilometerNum,1,1));


        if(is_array($KilometerData))


        {


            foreach($KilometerData as $key=>$data)


            {


               if($data['from_kilometer'] <= $kilometerNum && $data['to_kilometer'] >= $kilometerNum)


               {


                   return $data;


               }


            }


            return FALSE;


        }


        return FALSE;


    }


    public function GetCommissionByKilometerPriceId($price_id)


    {


        $commissionData = $this->loadModel("CommissionModel")->retrieveAllData("WHERE `kilometer_price_id` = ? AND `status` =? AND `deleted` =? ORDER BY `id` DESC LIMIT 1",array($price_id,1,1));


        if(is_array($commissionData))


        {


           return array_shift($commissionData); 


        }


        return FALSE;


    }


    public function calculateCommissionByKilometerPriceIdAndAmount($price_id,$amount)


    {


        $commissionData = $this->loadModel("CommissionModel")->retrieveAllData("WHERE `kilometer_price_id` = ? AND `status` =? AND `deleted` =? ORDER BY `id` DESC LIMIT 1",array($price_id,1,1));


        $data['driverCommission'] = 0;


        $data['passengerCommission'] = 0;


        $data['companyCommission'] = 0;


        if(is_array($commissionData))


        {


           $data['driverCommission'] = $amount * ($commissionData[0]['driver_commission_rate'] / 100);


           $data['passengerCommission'] = $amount * ($commissionData[0]['passenger_commission_rate'] / 100);


           $data['companyCommission'] = $amount * ($commissionData[0]['company_commission_rate'] / 100);


        }


        return $data;


    }


    public function generateRandomString($length = 10) 


    {


        return substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length/strlen($x)) )),1,$length);


    }


    public function getAvailableSeatsByCarIdAndTripId($car_id,$trip_id) 


    {


        $seats = 0;


        // get trip data


        $tripData = $this->loadModel("TripModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?",array($trip_id,1));


        $carData = $this->loadModel("CarModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?",array($car_id,1));


        // check data


        if(is_array($tripData) && is_array($carData))


        {


            // get sum seats from passenger join trip


            $seatsSum = $this->loadModel("PassengerJoinTripModel")->retrieveDataByQuery("SELECT SUM(seats) AS `seatsNum` FROM `passenger_join_trip` WHERE `id_trip` =? AND `status` =? AND `deleted` =?",array($trip_id,1,1));


            // seats Number


            $seatsNum = $seatsSum[0]['seatsNum'];


            $seats = ($carData[0]['seats_number'] - $seatsNum);


        }


        return $seats;


    }


    public function GetDriverPointsByKilometer($kilometerNum)


    {


        $ponisData = $this->loadModel("PointDriverKilometerModel")->retrieveAllData("WHERE `from_kilometer` <= ? AND `to_kilometer` >= ? AND `status` =? AND `deleted` =? ORDER BY `id` DESC",array($kilometerNum,$kilometerNum,1,1));


        if(is_array($ponisData))


        {


            foreach($ponisData as $key=>$data)


            {


               if($data['from_kilometer'] <= $kilometerNum && $data['to_kilometer'] >= $kilometerNum)


               {


                   return $data;


               }


            }


            return NULL;


        }


        return NULL;


    }


    public function GetPassengerPointsByKilometer($kilometerNum)


    {


        $ponisData = $this->loadModel("PointPassengerKilometerModel")->retrieveAllData("WHERE `from_kilometer` <= ? AND `to_kilometer` >= ? AND `status` =? AND `deleted` =? ORDER BY `id` DESC",array($kilometerNum,$kilometerNum,1,1));


        if(is_array($ponisData))


        {


            foreach($ponisData as $key=>$data)


            {


               if($data['from_kilometer'] <= $kilometerNum && $data['to_kilometer'] >= $kilometerNum)


               {


                   return $data;


               }


            }


            return NULL;


        }


        return NULL;


    }








}


?> 