<?php
class TripHelper extends controller{
	
	public function GetKilometerPriceDataByKilometerNum($kilometerNum)
    {
        $KilometerData = $this->loadModel("KilometerModel")->retrieveAllData("WHERE `from_kilometer` <= ? AND `to_kilometer` >= ? AND `status` =? AND `deleted` =? ORDER BY `id` DESC",array($kilometerNum,$kilometerNum,1,1));
        if(is_array($KilometerData))
        {
            foreach($KilometerData as $key=>$data)
            {
               if($data['from_kilometer'] <= $kilometerNum && $data['to_kilometer'] >= $kilometerNum)
               {
                   return $data;
               }
            }
            return FALSE;
        }
        return FALSE;
    }
    public function GetCommissionByKilometerPriceId($price_id)
    {
        $commissionData = $this->loadModel("CommissionModel")->retrieveAllData("WHERE `kilometer_price_id` = ? AND `status` =? AND `deleted` =? ORDER BY `id` DESC LIMIT 1",array($price_id,1,1));
        if(is_array($commissionData))
        {
           return array_shift($commissionData); 
        }
        return FALSE;
    }
    public function calculateCommissionByKilometerPriceIdAndAmount($price_id,$amount)
    {
        $commissionData = $this->loadModel("CommissionModel")->retrieveAllData("WHERE `kilometer_price_id` = ? AND `status` =? AND `deleted` =? ORDER BY `id` DESC LIMIT 1",array($price_id,1,1));
        $data['driverCommission'] = 0;
        $data['passengerCommission'] = 0;
        $data['companyCommission'] = 0;
        if(is_array($commissionData))
        {
           $data['driverCommission'] = $amount * ($commissionData[0]['driver_commission_rate'] / 100);
           $data['passengerCommission'] = $amount * ($commissionData[0]['passenger_commission_rate'] / 100);
           $data['companyCommission'] = $amount * ($commissionData[0]['company_commission_rate'] / 100);
        }
        return $data;
    }
    public function generateRandomString($length = 10) 
    {
        return substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length/strlen($x)) )),1,$length);
    }

}
?> 