<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <?php
            echo isset($title) ? $title : NULL;
            ?>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-lg-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title ">Show / Edit branches</h3>
                        <a class="btn btn-primary pull-right" href="<?php echo BASE_URL . "branches/add" ?>"><i
                                    class="fa fa-plus" aria-hidden="true"></i> Add a New Branch</a>
                    </div>
                    <!-- /.box-header -->
                    <div class="adminform">

                        <!-- form start -->
                        <table id="all_data" class="table table_for_data table-striped table-bordered dt-responsive nowrap tableData" cellspacing="0" width="100%">
                            <thead>
                            <tr>
                                <th>Id</th>
                                <th>Title</th>
                                <th>Date</th>
                                <th>status</th>
                                <th>action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            if (isset($branches) && is_array($branches)) {
                                foreach ($branches as $key => $data) {
                                    echo '<tr id="row' . $data['id'] . '">
                                                    <td>' . $data['id'] . '</td>
                                                    <td>' . $branchesEn[$key]['title'] . "<br >" . $branchesAr[$key]['title'] . '</td>
                                                    <td>' . $data['createdAt'] . '</td>
                                                 ';

                                    echo '</td>
                                                    <td>';
                                    if ($data['status'] == 1) {
                                        echo '<span data-id="' . $data['id'] . '" title="update Status" data-target="on" class="status on update' . $data['id'] . '">on</span>';
                                    } else {
                                        echo '<span data-id="' . $data['id'] . '" title="update Status" data-target="off" class="status off update' . $data['id'] . '">off</span>';
                                    }
                                    echo '</td>
                                                    <td>
                                                        <ul class="actions">
                                                         <li><a href="' . BASE_URL . "branches/edit_selected/" . $data['id'] . '" class="" id="' . $data['id'] . '"  title="Edit"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a></li>
                                                         <li><a href="" data-toggle="modal" data-id="' . $data['id'] . '" data-target="#deleteModal" class="deleteIcon" title="Delete"><i class="fa fa-trash" aria-hidden="true"></i>  </a></li>
                                                        </ul>
                                                    </td>
                                                  </tr>';
                                }
                            } else {
                                echo '<tr><td colspan="4">No Data Found</td></tr>';
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.box -->
            </div>
        </div>
    </section><!-- /.content -->
</div><!-- /.content-wrapper -->

<!-- Start Delete Modal -->
<div class="modal fade" id="deleteModal" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Confirm delete Your Data</h4>
            </div>
            <div class="modal-body">
                <div id="deleteResult"></div>
                <p>Are You Sure ? </p>
                <input type="submit" class="btn btn-primary del" name="delete" value="Delete"/>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!--End Delete Modal-->


<script>
    $(document).ready(function () {
        $('#all_data').DataTable();
        // start delete
        $(".table_for_data").on('click', '.deleteIcon', function () {
            $("#deleteResult").html("");
            var myId = $(this).attr("data-id");
            var myaction = "deleteData";
            var allData = {"action": myaction, "id": myId};
            $(".del").click(function () {
                $.ajax({
                    url: "<?php echo BASE_URL . 'branches/delete' ?>",
                    type: "POST",
                    data: allData,
                    beforeSend: function () {
                    },
                    statusCode: {
                        404: function () {
                            alert("page not found");
                        },
                    },
                    success: function (valdata) {
                        var da = jQuery.parseJSON(valdata);
                        if (da['status'] == "success") {
                            $("#deleteResult").html('<div class="alert alert-success" role="alert"><strong>Success </strong> Data Deleted Successfuly </div>');
                            $('#deleteModal').modal('hide')
                            $("#row" + myId).fadeOut(1000);
                        } else {
                            $("#deleteResult").html('<div class="alert alert-danger" role="alert"><strong> Error ! </strong> Error Deleting  Your Data </div>');
                        }
                    }
                });
                return false;
            });
        });
        // end delete
        //start update  status
        $(".table_for_data").on('click', '.status', function () {
            var myId = $(this).attr("data-id");
            var myaction = "updateStatus";
            var mystatus = $(this).attr("data-target");
            var allData = {"action": myaction, "id": myId, "status": mystatus};
            $.ajax({
                url: "<?php echo BASE_URL . 'branches/updateStatus' ?>",
                type: "POST",
                data: allData,
                beforeSend: function () {
                },
                statusCode: {
                    404: function () {
                        alert("page not found");
                    },
                },
                success: function (valdata) {
                    var da = JSON.parse(valdata);
                    if (da['status'] == "success") {
                        if (mystatus == "on") {
                            $(".update" + myId).removeClass("on");
                            $(".update" + myId).html("off");
                            $(".update" + myId).addClass("off");
                            $(".update" + myId).attr("data-target", "off");
                        } else {
                            $(".update" + myId).removeClass("off");
                            $(".update" + myId).html("on");
                            $(".update" + myId).addClass("on");
                            $(".update" + myId).attr("data-target", "on");
                        }
                    } else {
                        alert("faild");
                    }
                }
            });
            return false;
        });

        //end update status

    });
</script>
