<?php

class Setting extends Controller
{

    public function edit()
    {
        //******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("error", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/
        if (isset($_POST['editSetting'])) {
            // preparing validation array
            $DataValid = array(
                "name" => array(
                    "value" => $this->loadSecurity($_POST['name'])->clear(),
                    "errorName" => "Website Name",
                    "rules" => "min-length[2]"
                ),
                "mail" => array(
                    "value" => $this->loadSecurity($_POST['mail'])->clear(),
                    "errorName" => "Company Email",
                    "rules" => "required|email"
                ),
                "description" => array(
                    "value" => $this->loadSecurity($_POST['description'])->clear(),
                    "errorName" => "Website Description",
                    "rules" => "min-length[4]"
                ),
                "name_ar" => array(
                    "value" => $this->loadSecurity($_POST['name_ar'])->clear(),
                    "errorName" => "أسم الموقع",
                    "rules" => "min-length[2]"
                ),
                "description_ar" => array(
                    "value" => $this->loadSecurity($_POST['description_ar'])->clear(),
                    "errorName" => "وصف الموقع",
                    "rules" => "min-length[4]"
                ),
                "address_ar" => array(
                    "value" => $this->loadSecurity($_POST['address_ar'])->clear(),
                    "errorName" => "عنوان الشركة",
                    "rules" => "required"
                ),
                "phone" => array(
                    "value" => $this->loadSecurity($_POST['phone'])->clear(),
                    "errorName" => "Company Phone",
                    "rules" => "min-length[10]"
                ),
                "another_phone" => array(
                    "value" => $this->loadSecurity($_POST['another_phone'])->clear(),
                    "errorName" => "Company Another Phone",
                    "rules" => "required"
                ),
                "address" => array(
                    "value" => $this->loadSecurity($_POST['address'])->clear(),
                    "errorName" => "Company Address",
                    "rules" => "required"
                ),
                "facebook" => array(
                    "value" => $this->loadSecurity($_POST['facebook'])->clear(),
                    "errorName" => "FaceBook Link",
                    "rules" => "required|url"
                ),
                "twitter" => array(
                    "value" => $this->loadSecurity($_POST['twitter'])->clear(),
                    "errorName" => "Twitter Link",
                    "rules" => "required|url"
                ),
                "google" => array(
                    "value" => $this->loadSecurity($_POST['google'])->clear(),
                    "errorName" => "Google+ Link",
                    "rules" => "required|url"
                ),
                "youtube" => array(
                    "value" => $this->loadSecurity($_POST['youtube'])->clear(),
                    "errorName" => "YouTube Link",
                    "rules" => "required|url"
                ),
                "instagram" => array(
                    "value" => $this->loadSecurity($_POST['instagram'])->clear(),
                    "errorName" => "Instagram Link",
                    "rules" => "required|url"
                ),
                "linkedin" => array(
                    "value" => $this->loadSecurity($_POST['linkedin'])->clear(),
                    "errorName" => "LinkedIn Link",
                    "rules" => "required|url"
                ),
                "snapchat" => array(
                    "value" => $this->loadSecurity($_POST['snapchat'])->clear(),
                    "errorName" => "snapchat Link",
                    "rules" => "required|url"
                ),
                "pinterest" => array(
                    "value" => $this->loadSecurity($_POST['pinterest'])->clear(),
                    "errorName" => "pinterest Link",
                    "rules" => "required|url"
                ),
                "vk" => array(
                    "value" => $this->loadSecurity($_POST['vk'])->clear(),
                    "errorName" => "Vk Link",
                    "rules" => "required|url"
                ),

                "location" => array(
                    "value" => $this->loadSecurity($_POST['location'])->clear(),
                    "errorName" => "location Link",
                    "rules" => "required|url"
                ),
                "status" => array(
                    "value" => $this->loadSecurity($_POST['status'])->clear(),
                    "errorName" => "Website Status",
                    "required" => "required",
                    "number" => "number"
                ),


            );
            // load validation class and pass validation data
            $validationResult = $this->loadValidation($DataValid)->formValidate();
            // check if the data is ok
            if(is_array($validationResult) && array_key_exists("success",$validationResult)){
                // preparing data model
                $dataModel['mail'] = $validationResult['success']['mail'];
                $dataModel['phone'] = $validationResult['success']['phone'];
                $dataModel['another_phone'] = $validationResult['success']['another_phone'];
                $dataModel['facebook'] = $validationResult['success']['facebook'];
                $dataModel['twitter'] = $validationResult['success']['twitter'];
                $dataModel['google'] = $validationResult['success']['google'];
                $dataModel['youtube'] = $validationResult['success']['youtube'];
                $dataModel['instagram'] = $validationResult['success']['instagram'];
                $dataModel['linkedin'] = $validationResult['success']['linkedin'];
                $dataModel['snapchat'] = $validationResult['success']['snapchat'];
                $dataModel['pinterest'] = $validationResult['success']['pinterest'];
                $dataModel['vk'] = $validationResult['success']['vk'];
                $dataModel['location'] = $validationResult['success']['location'];
                $dataModel['status'] = $validationResult['success']['status'];
                // load model and Add data
                if (FALSE !== $this->loadModel("SettingModel", $dataModel)->updateData("id", 1)) {
                    // preparing lang data
                    $dataModelEn['name'] = $validationResult['success']['name'];
                    $dataModelEn['description'] = $validationResult['success']['description'];
                    $dataModelEn['address'] = $validationResult['success']['address'];
                    $this->loadModel("SettingEnModel", $dataModelEn)->updateData("id_setting", 1);
                    // ang ar
                    $dataModelAr['name'] = $validationResult['success']['name_ar'];
                    $dataModelAr['description'] = $validationResult['success']['description_ar'];
                    $dataModelAr['address'] = $validationResult['success']['address_ar'];
                    $this->loadModel("SettingArModel", $dataModelAr)->updateData("id_setting", 1);

                    $dataView['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i> success </strong> Your Settings Updated Successfuly Please Wait ... </div>';
                    header("Refresh: 2");
                } else {
                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data</div>';
                }

            } else {
                $dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>'.$validationResult.'</div>';
            }
        }

        // get website date
        $site_info = $this->loadModel("SettingModel")->retrieveAllData();
        if ($site_info != NULL) {
            $dataView['site'] = array_shift($site_info);
            $dataView['site_en'] = $this->loadModel("SettingEnModel")->retriveDataById("id_setting", 1);
            $dataView['site_ar'] = $this->loadModel("SettingArModel")->retriveDataById("id_setting", 1);
        } else {
            $this->redirect("error", "index");
            exit;
        }

        // set page title
        $dataView['title'] = "Edit WebSite Information";
        // global TEMPLATE_BACK_END
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "setting_edit";
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

    public function update_image()
    {
        $upload = $this->loadUpload("image_name")->do_upload();
        // check if there is error on image
        if (array_key_exists("uploadError", $upload)) {
            echo $this->loadAjax()->DataToJson(array("status" => "falid", "message" => $upload['uploadError']));
            exit;
        } else {
            $dataModel['logo'] = $upload['uploaded'][0];
            if (false !== $this->loadModel("SettingModel", $dataModel)->updateData("id", 1)) {
                echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['logo']));
                exit;
            } else {
                echo $this->loadAjax()->DataToJson(array("status" => "falid"));
                exit;
            }
        }
    }
}

?>
