<?php

class Home extends Controller
{


    public function index()
    {

        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            $dataView['employeeData'] = $this->loadModel("EmployeeModel")->retriveDataById("user_id", $user_id);
            if ($dataView['userData'] == NULL || $dataView['employeeData'] == NULL) {
                $this->redirect("error", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }
        /******* end header code *******/
        // get total data
        $dataView['total_messages'] = $this->loadModel("UserMessageModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `user_message` WHERE `deleted` =?", array(1));
        $dataView['total_employees'] = $this->loadModel("EmployeeModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `employee` WHERE `deleted` =?", array(1));
        $dataView['total_cats'] = $this->loadModel("CategoryModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `categories` WHERE `deleted` =?", array(1));
        $dataView['total_branches'] = $this->loadModel("OfferModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `branches` WHERE `deleted` =?", array(1));
        $dataView['total_products'] = $this->loadModel("OfferModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `offer` WHERE `deleted` =?", array(1));
        $dataView['sum_messages'] = $this->loadModel("UserMessageModel")->retrieveDataByQuery("SELECT * FROM `user_message` WHERE `deleted` =?  ORDER BY `id` DESC LIMIT 5  ", array(1));


        $dataView['title'] = "Home Page";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "home_page";
        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

}

?>
