<?php

class Home extends Controller
{

    private function getSEO()
    {
        $url = parse_url($_SERVER['REQUEST_URI']);
        $slug = $url['path'];
        $result = $this->loadModel("SeoModel")->retrieveAllData("WHERE `slug` =? ", array($slug));
        if($result && count($result)) {
            $seo = $result[0];
        } else {
            $seo = [
                'slug' => null,
                'title' => null,
                'keywords' => null,
                'content' => null
            ];
        }

        return $seo;
    }

    public function index()
    {
        $dataView['SEO'] = $this->getSEO();
        /******* end header code *******/
        $dataView['current'] = "home";
        /// slider
        $dataView['sliders'] = $this->loadModel("SliderModel")->retrieveAllData("WHERE `status` =? AND `deleted` =? ", array(1, 1));
        if (is_array($dataView['sliders'])) {
            foreach ($dataView['sliders'] as $key => $value) {
                // get ar and en Data
                $dataView['slidersLang'][$key] = $this->loadModel("SliderArModel")->retriveDataById("id_sliders", $value['id']);
            }
        }
        /// features
        $dataView['features'] = $this->loadModel("FeaturesModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?   ", array(1, 1));
        if (is_array($dataView['features'])) {
            foreach ($dataView['features'] as $key => $value) {
                // get ar and en Data
                $dataView['featuresLang'][$key] = $this->loadModel("FeaturesArModel")->retriveDataById("id_features", $value['id']);
            }
        }
        //categories
        $dataView['categories'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?", array(1, 1));
        if (is_array($dataView['categories'])) {
            foreach ($dataView['categories'] as $key => $value) {
                // get ar and en Data
                $dataView['categoriesLang'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $value['id']);
                // products
                $dataView['products'][$key] = $this->loadModel("OfferModel")->retrieveAllData("WHERE `id_category` =? AND `status` =? AND `deleted` =?", array($value['id'], 1, 1));
                foreach ($dataView['products'][$key] as $key2 => $data) {
                    $dataView['productsLang'][$key][$key2] = $this->loadModel("OfferArModel")->retriveDataById("id_offer", $data['id']);
                }

            }
        }
        /// photo
        $dataView['photos'] = $this->loadModel("ImageGalleryModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?   ", array(1, 1));
        if (is_array($dataView['photos'])) {
            foreach ($dataView['photos'] as $key => $value) {
                // get ar and en Data
                $dataView['photosLang'][$key] = $this->loadModel("ImageGalleryArModel")->retriveDataById("id_image_gallery", $value['id']);
            }
        }
        /// clients
        $dataView['clients'] = $this->loadModel("GalleryModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?   ", array(1, 1));

        /// About
        $dataView['about'] = $this->loadModel("AboutusModel")->retriveDataById("id", 1);
        $dataView['aboutLang'] = $this->loadModel("AboutusArModel")->retriveDataById("id_about_us", 1);


        // set page title
        $dataView['title'] = "المصرية للمعادن| الرئيسية";
        // global Template Config
        global $TEMPLATE_FRONT_END;

        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "index_view";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }

    public function aboutus()
    {
        $dataView['SEO'] = $this->getSEO();

        $dataView['current'] = "aboutus";
        /******* end header code *******/

        /// About
        $dataView['about'] = $this->loadModel("SeoModel")->retriveDataById("id", 1);
        $dataView['aboutLang'] = $this->loadModel("AboutusArModel")->retriveDataById("id_about_us", 1);



        $dataView['title'] = "المصرية للمعادن| من نحن";
        // global Template Config
        global $TEMPLATE_FRONT_END;
        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "aboutus";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }

    public function gallery()
    {
        $dataView['SEO'] = $this->getSEO();
        $dataView['current'] = "gallery";
        /******* end header code *******/

        /// photo
        $dataView['photos'] = $this->loadModel("ImageGalleryModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?   ", array(1, 1));
        if (is_array($dataView['photos'])) {
            foreach ($dataView['photos'] as $key => $value) {
                // get ar and en Data
                $dataView['photosLang'][$key] = $this->loadModel("ImageGalleryArModel")->retriveDataById("id_image_gallery", $value['id']);
            }
        }


        $dataView['title'] = "المصرية للمعادن| العملاء";
        // global Template Config
        global $TEMPLATE_FRONT_END;
        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "gallery_view";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }

    public function contactus()
    {
        $dataView['SEO'] = $this->getSEO();
        $dataView['current'] = "contactus";


        /// branches
        $dataView['branches'] = $this->loadModel("BranchesModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?   ", array(1, 1));
        if (is_array($dataView['branches'])) {
            foreach ($dataView['branches'] as $key => $value) {
                // get ar and en Data
                $dataView['branchesLang'][$key] = $this->loadModel("BranchesArModel")->retriveDataById("id_branch", $value['id']);
                $dataView['branchesPhone'][$key] = $this->loadModel("BranchesPhoneModel")->retrieveAllData("WHERE `id_branch`=? AND `status`=? AND `deleted` =?", array($value['id'], 1, 1));
            }
        }

        $dataView['title'] = "EG | Contact Us";
        // global Template Config
        global $TEMPLATE_FRONT_END;
        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "contactus";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }

    public function SendMessageForm()
    {
        if (isset($_POST['action']) && $_POST['action'] == "addsentmessagedata") {
            // preparing validation array
            $validationArray = array(
                "name_data" => array(
                    "value" => $this->loadSecurity($_POST['name'])->clear(),
                    "errorName" => "الاسم",
                    "rules" => "required|min-length[1]"
                ),
                "phone_data" => array(
                    "value" => $this->loadSecurity($_POST['phone'])->clear(),
                    "errorName" => "الموبايل",
                    "rules" => "required|number|min-length[1]"
                ),
                "email_data" => array(
                    "value" => $this->loadSecurity($_POST['email'])->clear(),
                    "errorName" => "البريد",
                    "rules" => "required|min-length[1]"
                ),
                "subject_data" => array(
                    "value" => $this->loadSecurity($_POST['subject'])->clear(),
                    "errorName" => "الموضوع",
                    "rules" => "required|min-length[1]"
                ),
                "message_data" => array(
                    "value" => $this->loadSecurity($_POST['message'])->clear(),
                    "errorName" => " الرسالة",
                    "rules" => "required|min-length[1]"
                ),
            );
            // load validation class and pass validation data
            $dataValid = $this->loadValidation($validationArray)->formValidate();
            // check if the data is ok
            if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
                $datToModel['name'] = $dataValid['success']['name_data'];
                $datToModel['phone'] = $dataValid['success']['phone_data'];
                $datToModel['mail'] = $dataValid['success']['email_data'];
                $datToModel['subject'] = $dataValid['success']['subject_data'];
                $datToModel['message'] = $dataValid['success']['message_data'];
                $datToModel['created'] = time();
                $dataValid['success']['date'] = date('Y-m-d h:i:s');
                $add = $this->loadModel("UserMessageModel", $datToModel)->add();
                if (FALSE !== $add) {
                    $data['status'] = "success";
                    $data['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i> All Data Added Successfully <strong> Thanks....</strong></div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                } else {
                    $data['status'] = "failed";
                    $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> <strong>Failed ! </strong> Failed To Send This Request Please Try Again....</div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                }

            } else {
                $data['status'] = "failed";
                $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Failed ! </strong> ' . $dataValid . '</div>';
                echo $this->loadAjax()->DataToJson($data);
                exit();
            }

        }
    }

    public function SendRequestForm()
    {
        if (isset($_POST['action']) && $_POST['action'] == "addsentrequestdata") {
            // preparing validation array
            $validationArray = array(
                "email_data" => array(
                    "value" => $this->loadSecurity($_POST['email'])->clear(),
                    "errorName" => "البريد",
                    "rules" => "required|email|min-length[1]"
                ),
            );
            // load validation class and pass validation data
            $dataValid = $this->loadValidation($validationArray)->formValidate();
            // check if the data is ok
            if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
                // add
                $datToModel['mail'] = $dataValid['success']['email_data'];
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                $datToModel['created_by'] = $user_id;
                $datToModel['createdAt'] = date('Y-m-d h:i:s');
                $add = $this->loadModel("RequestModel", $datToModel)->add();
                if (FALSE !== $add) {
                    $data['status'] = "success";
                    $data['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i>  نجاح </strong> تم  اضافه البيانات بنجاح ... </div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                } else {
                    $data['status'] = "failed";
                    $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> خطا ! </strong> خطا في اضافه البيانات برجاء المحاوله مره اخري ....</div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                }
            } else {
                $data['status'] = "failed";
                $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> خطا ! </strong> ' . $dataValid . '</div>';
                echo $this->loadAjax()->DataToJson($data);
                exit();
            }
        }
    }


}

?>
