<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Connectors;

class ListEntityTypesResponse extends \Google\Collection
{
  protected $collection_key = 'unsupportedTypeNames';
  /**
   * @var array[]
   */
  public $metadata;
  /**
   * @var string
   */
  public $nextPageToken;
  protected $typesType = EntityType::class;
  protected $typesDataType = 'array';
  /**
   * @var string[]
   */
  public $unsupportedTypeNames;

  /**
   * @param array[]
   */
  public function setMetadata($metadata)
  {
    $this->metadata = $metadata;
  }
  /**
   * @return array[]
   */
  public function getMetadata()
  {
    return $this->metadata;
  }
  /**
   * @param string
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * @param EntityType[]
   */
  public function setTypes($types)
  {
    $this->types = $types;
  }
  /**
   * @return EntityType[]
   */
  public function getTypes()
  {
    return $this->types;
  }
  /**
   * @param string[]
   */
  public function setUnsupportedTypeNames($unsupportedTypeNames)
  {
    $this->unsupportedTypeNames = $unsupportedTypeNames;
  }
  /**
   * @return string[]
   */
  public function getUnsupportedTypeNames()
  {
    return $this->unsupportedTypeNames;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListEntityTypesResponse::class, 'Google_Service_Connectors_ListEntityTypesResponse');
