<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<form class="default-form" action="<?php echo e(Path::AppUrl('save-contact-us')); ?>" method="post">
    <?php echo csrf_field(); ?>
    <div class="row clearfix">
        <div class="col-lg-6 col-md-6 col-sm-12 form-group">
            <input type="text" name="name" placeholder="<?php echo e(__('website.name')); ?>" required>
        </div>
        <div class="col-lg-6 col-md-12 col-sm-12 form-group">
            <input type="text" name="email" placeholder="<?php echo e(__('website.email')); ?>" required>
        </div>
        <div class="col-lg-12 col-md-12 col-sm-12 form-group">
            <input type="text" name="phone" placeholder="<?php echo e(__('website.phone')); ?>" required>
        </div>
        <div class="col-lg-12 col-md-12 col-sm-12 form-group">
            <textarea name="message" id="" cols="60" rows="5" placeholder="<?php echo e(__('website.message')); ?>"
                required=""></textarea>
        </div>
        
        <input type="hidden" name="recaptcha_token" id="recaptcha_token">
        <div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn mr-0">
            <button class="theme-btn btn-one" type="submit" title="submit-form"
                name="submit-form"><span><?php echo e(__('website.send')); ?></span></button>
        </div>
    </div>
</form>
<!-- <======================= EndContactForm =========================> -->
<?php if(config('captcha.sitekey') && config('captcha.sitekey') !== 'Key'): ?>
    <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(config('captcha.sitekey')); ?>"></script>

    <script>
        grecaptcha.ready(function() {
            grecaptcha.execute('<?php echo e(config('captcha.sitekey')); ?>', {
                action: 'contact'
            }).then(function(token) {
                document.getElementById('recaptcha_token').value = token;
            }).catch(function(error) {
                console.warn('reCAPTCHA error:', error);
            });
        });
    </script>
<?php else: ?>
    <script>
        console.warn('reCAPTCHA is not configured properly. Please set NOCAPTCHA_SITEKEY in your .env file');
    </script>
<?php endif; ?>
<?php /**PATH /home/webtest3/public_html/dhi/resources/views/components/website/partials/contact-form.blade.php ENDPATH**/ ?>