<!--====================Site Footer==============-->
<footer class="main-footer">
    <div class="container">
        <div class="footer-top">
            <div class="top-inner">
                <div class="text">
                    <h5><?php echo e(__('website.email')); ?></h5>
                    <h3><a href="mailto:<?php echo e(config('settings.site_email')); ?>"><?php echo e(config('settings.site_email')); ?></a></h3>
                </div>
                <figure class="footer-logo">
                    <a href="<?php echo e(Path::AppUrl('/')); ?>">
                        <img src="<?php echo e(Path::FooterLogo()); ?>" class="logo_main" alt="logo" width="150"
                            height="75">
                    </a>
                </figure>
                <div class="text">
                    <h5><?php echo e(__('website.call_us')); ?></h5>
                    <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($phone->type == 'phone'): ?>
                            <h3><a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>" target="_blank" aria-label="mobile number"><i
                                        class="far fa-phone"><?php echo e($phone->code); ?><?php echo e($phone->phone); ?></i></a></h3>
                        <?php elseif($phone->type == 'whatsapp'): ?>
                            <h3><a href="https://wa.me/<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>" target="_blank" aria-label="whatsapp number"><i
                                        class="fab fa-whatsapp"><?php echo e($phone->code); ?><?php echo e($phone->phone); ?></i></a></h3>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <div class="widget-section">
            <div class="row clearfix">
                <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                    <div class="footer-widget links-widget">
                        <div class="widget-title">
                            <h4><?php echo e(__('website.working_hours')); ?></h4>
                        </div>
                        <div class="widget-content">
                            <p>
                                <span><i class="fa fa-clock"></i> <?php echo e(__('website.working_hours')); ?>:</span>
                                من السبت إلى الأربعاء من الساعة 3 عصراً حتى الساعة 8 مساءً
                            </p>
                            <p>
                                <span><i class="fa fa-clock"></i> <?php echo e(__('website.working_hours')); ?>:</span>
                                الخميس - الجمعة مغلق
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                    <div class="footer-widget contact-widget">
                        <div class="widget-title">
                            <h4><?php echo e(__('website.our_location')); ?></h4>
                        </div>
                        <div class="widget-content">
                            <?php $__currentLoopData = $site_addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <p><a href="<?php echo e($address->map_link); ?>" target="_blank"><?php echo e($address->title); ?>: <?php echo e($address->address); ?></a></p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 footer-column">
                    <div class="footer-widget contact-widget">
                        <div class="widget-title">
                            <h4><?php echo e(__('website.social_media')); ?></h4>
                        </div>
                        <div class="widget-content">
                            <ul class="social-links clearfix">
                                <li><a href="<?php echo e($socialMediaLinks['twitter']); ?>" target="_blank" aria-label="Twitter Link"><i
                                            class="fab fa-twitter"></i></a></li>
                                <li><a href="<?php echo e($socialMediaLinks['facebook']); ?>" target="_blank"
                                        aria-label="Facebook Link"><i class="fab fa-facebook"></i></a></li>
                                <li><a href="<?php echo e($socialMediaLinks['instagram']); ?>" target="_blank"
                                        aria-label="Instagram Link"><i class="fab fa-instagram"></i></a></li>
                                <li><a href="<?php echo e($socialMediaLinks['youtube']); ?>" target="_blank"
                                        aria-label="Youtube Link"><i class="fab fa-youtube"></i></a></li>
                                <li><a href="<?php echo e($socialMediaLinks['tiktok']); ?>" target="_blank"
                                        aria-label="Tik tok Link"><img loading="lazy"
                                            src="<?php echo e(Path::FrontImage('tik-tok.png')); ?>" alt="tiktok image"
                                            width="15" height="15" /></a></li>
                                <li><a href="<?php echo e($socialMediaLinks['snapchat']); ?>" target="_blank"
                                        aria-label="Snapchat Link"><i class="fab fa-snapchat"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom centred">
        <div class="container">
            <div class="copyright">
                <p>All Rights Reserved DHI Egypt, Developed and Designed by <a href="https://be-group.com"
                        target="_blank">Be Group</a></p>
            </div>
        </div>
    </div>
</footer>
<!-- main-footer end -->

<!-- scroll to top -->
<button class="scroll-top scroll-to-target" data-target="html" aria-label="scroll to top">
    <i class="fas fa-arrow-up"></i>
</button>
<!--====================Footer==============-->
<?php /**PATH /home/webtest3/public_html/dhi/resources/views/components/website/partials/_footer.blade.php ENDPATH**/ ?>