<!-- Mobile Menu  -->
<div class="mobile-menu">
    <div class="menu-backdrop"></div>
    <div class="close-btn"><i class="fas fa-times"></i></div>

    <nav class="menu-box">
        <div class="nav-logo">
            <a href="<?php echo e(Path::AppUrl('/')); ?>">
                <img src="<?php echo e(Path::AppLogo('site_logo')); ?>" class="logo_main" alt="logo" width="25" height="25"
                    loading="lazy">
            </a>
        </div>
        <div class="menu-outer">
        </div>
        <div class="contact-info">
            <h4><?php echo e(__('website.contact_us')); ?></h4>
            <ul>
                <?php if(isset($site_addresses) && is_iterable($site_addresses)): ?>
                    <?php $__currentLoopData = $site_addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e($address->map_link ?? '#'); ?>" target="_blank"><?php echo e($address->address ?? ''); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php if(isset($phones) && is_iterable($phones)): ?>
                    <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="tel:<?php echo e($phone->code ?? ''); ?><?php echo e($phone->phone ?? ''); ?>"
                                aria-label="Mobile Number"><?php echo e($phone->phone ?? ''); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php if(isset($site_addresses) && is_object($site_addresses) && isset($site_addresses->email)): ?>
                    <li><a href="mailto:<?php echo e($site_addresses->email); ?>"
                            aria-label="Contact Mail"><?php echo e($site_addresses->email); ?></a></li>
                <?php endif; ?>
            </ul>
        </div>
        <div class="social-links">
            <ul class="clearfix">
                <?php $__currentLoopData = $socialMediaLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platform => $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($link && $link != '#'): ?>
                        <li><a href="<?php echo e($link); ?>" target="_blank"><i
                                    class="fab fa-<?php echo e($platform); ?>"></i></a></li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </ul>
        </div>
    </nav>

</div>
<!-- End Mobile Menu -->
<?php /**PATH /home/webtest3/public_html/dhi/resources/views/components/website/partials/mobilemenu.blade.php ENDPATH**/ ?>