<!--=============== Heder ============= -->
<header class="main-header header-style-one">
    <div class="header-lower">
        <div class="outer-box">
            <div class="logo-box">
                <figure class="logo">
                    <a href="{{ Path::AppUrl('/') }}">
                        <img src="{{ Path::AppLogo('site_logo') }}" class="logo_main" alt="logo" width="150"
                            height="75">
                    </a>
                </figure>
            </div>
            <div class="menu-area">
                <!--Mobile Navigation Toggler-->
                <div class="mobile-nav-toggler">
                    <i class="icon-bar"></i>
                    <i class="icon-bar"></i>
                    <i class="icon-bar"></i>
                </div>
                @if (isset($menus) && $menus->count() > 0)
                    <x-website.partials.mainmenu :menus="$menus" />
                @endif
            </div>
            <div class="menu-right-content">
                @php
                    use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
                    $supportedLocales = config('laravellocalization.supportedLocales', []);
                    $currentLocale = app()->getLocale();

                    $flags = [
                        'en' => '🇺🇸',
                        'ar' => '🇸🇦',
                        'fr' => '🇫🇷',
                        'de' => '🇩🇪',
                        'es' => '🇪🇸',
                        'it' => '🇮🇹',
                        'pt' => '🇵🇹',
                        'ru' => '🇷🇺',
                        'zh' => '🇨🇳',
                        'ja' => '🇯🇵',
                        'ko' => '🇰🇷',
                        'tr' => '🇹🇷',
                    ];
                @endphp

                @if (count($supportedLocales) > 1)
                    <div class="language-switcher">
                        <div class="support-box">
                            <div class="icon">
                                <img loading="lazy" src="{{ asset('assets/website/images/globe.png') }}" alt="lang"
                                    width="25" height="25">
                            </div>
                            <div class="language-dropdown">
                                <button class="language-toggle" type="button">
                                    <span class="current-language">
                                        {{ $flags[$currentLocale] ?? '🌐' }}
                                        {{ $supportedLocales[$currentLocale]['native'] ?? strtoupper($currentLocale) }}
                                    </span>
                                    <i class="fas fa-chevron-down"></i>
                                </button>
                                <ul class="language-menu">
                                    @foreach ($supportedLocales as $code => $language)
                                        @if ($code !== $currentLocale)
                                            <li>
                                                <a hreflang="{{ $code }}"
                                                    href="{{ \App\Helpers\LocalizationHelper::getCurrentPageLocalizedUrl($code) }}"
                                                    class="language-option"
                                                    dir="{{ $language['script'] === 'Arab' ? 'rtl' : 'ltr' }}">
                                                    {{ $flags[$code] ?? '🌐' }} {{ $language['native'] }}
                                                </a>
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="support-box">
                        <div class="icon">
                            <img loading="lazy" src="resources/assets/front/images/globe.png" alt="lang"
                                width="25" height="25">
                        </div>
                        <h5>
                            <a hreflang="{{ $currentLocale }}" href="#">
                                {{ $supportedLocales[$currentLocale]['native'] ?? strtoupper($currentLocale) }}
                            </a>
                        </h5>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!--sticky Header-->
    <div class="sticky-header">
        <div class="outer-box">
            <div class="menu-area">
                <nav class="main-menu clearfix">
                    <!--Keep This Empty / Menu will come through Javascript-->
                </nav>
            </div>
            <div class="menu-right-content">
                @if (count($supportedLocales) > 1)
                    <div class="language-switcher">
                        <div class="support-box">
                            <div class="icon">
                                <img loading="lazy" src="{{ asset('assets/website/images/globe.png') }}" alt="lang"
                                    width="25" height="25">
                            </div>
                            <div class="language-dropdown">
                                <button class="language-toggle" type="button">
                                    <span class="current-language">
                                        {{ $flags[$currentLocale] ?? '🌐' }}
                                        {{ $supportedLocales[$currentLocale]['native'] ?? strtoupper($currentLocale) }}
                                    </span>
                                    <i class="fas fa-chevron-down"></i>
                                </button>
                                <ul class="language-menu">
                                    @foreach ($supportedLocales as $code => $language)
                                        @if ($code !== $currentLocale)
                                            <li>
                                                <a hreflang="{{ $code }}"
                                                    href="{{ \App\Helpers\LocalizationHelper::getCurrentPageLocalizedUrl($code) }}"
                                                    class="language-option"
                                                    dir="{{ $language['script'] === 'Arab' ? 'rtl' : 'ltr' }}">
                                                    {{ $flags[$code] ?? '🌐' }} {{ $language['native'] }}
                                                </a>
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="support-box">
                        <div class="icon">
                            <img loading="lazy" src="{{ asset('assets/website/images/globe.png') }}" alt="lang"
                                width="25" height="25">
                        </div>
                        <h5>
                            <a hreflang="{{ $currentLocale }}" href="#">
                                {{ $supportedLocales[$currentLocale]['native'] ?? strtoupper($currentLocale) }}
                            </a>
                        </h5>
                    </div>
                @endif
            </div>
        </div>
    </div>
</header>
<!-- main-header end -->
<!--=============== Heder ============= -->
<style>
    /* Language Switcher Styles */
    .language-switcher {
        position: relative;
        display: inline-block;
    }

    .language-dropdown {
        position: relative;
    }

    .language-toggle {
        background: none;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 8px 12px;
        border-radius: 4px;
        transition: background-color 0.3s ease;
    }

    .language-toggle:hover {
        background-color: rgba(255, 255, 255, 0.1);
    }

    .current-language {
        font-weight: 500;
        color: #333;
    }

    .language-toggle i {
        font-size: 12px;
        color: #666;
        transition: transform 0.3s ease;
    }

    .language-switcher.active .language-toggle i {
        transform: rotate(180deg);
    }

    .language-menu {
        position: absolute;
        top: 100%;
        right: 0;
        background: #fff;
        border: 1px solid #ddd;
        border-radius: 6px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        list-style: none;
        margin: 0;
        padding: 8px 0;
        min-width: 160px;
        z-index: 1000;
        opacity: 0;
        visibility: hidden;
        transform: translateY(-10px);
        transition: all 0.3s ease;
    }

    .language-switcher.active .language-menu {
        opacity: 1;
        visibility: visible;
        transform: translateY(0);
    }

    .language-menu li {
        margin: 0;
    }

    .language-option {
        display: block;
        padding: 10px 16px;
        color: #333;
        text-decoration: none;
        transition: background-color 0.2s ease;
        font-size: 14px;
    }

    .language-option:hover {
        background-color: #f8f9fa;
        color: #007bff;
    }

    /* RTL Support */
    .language-option[dir="rtl"] {
        text-align: right;
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .language-menu {
            right: auto;
            left: 0;
            min-width: 140px;
        }

        .current-language {
            font-size: 14px;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Handle language switcher dropdown
        const languageSwitchers = document.querySelectorAll('.language-switcher');

        languageSwitchers.forEach(function(switcher) {
            const toggle = switcher.querySelector('.language-toggle');
            const menu = switcher.querySelector('.language-menu');

            if (toggle && menu) {
                // Toggle dropdown
                toggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();

                    // Close other dropdowns
                    languageSwitchers.forEach(function(otherSwitcher) {
                        if (otherSwitcher !== switcher) {
                            otherSwitcher.classList.remove('active');
                        }
                    });

                    // Toggle current dropdown
                    switcher.classList.toggle('active');
                });
            }
        });

        // Close dropdowns when clicking outside
        document.addEventListener('click', function(e) {
            if (!e.target.closest('.language-switcher')) {
                languageSwitchers.forEach(function(switcher) {
                    switcher.classList.remove('active');
                });
            }
        });

        // Close dropdowns when pressing Escape
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                languageSwitchers.forEach(function(switcher) {
                    switcher.classList.remove('active');
                });
            }
        });
    });
</script>
