<?php

use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;


return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(function () {
        // Global routes (non-localized) - should come first for auth and redirects
        Route::middleware('web')
            ->group(base_path('routes/web.php'));

        // Website routes with localization
        Route::middleware(['web', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath', 'redirects', 'lang.redirect'])
            ->prefix(LaravelLocalization::setLocale())
            ->name('website.')
            ->group(base_path('routes/web/website/website.php'));

        Route::middleware(['web'])
            ->prefix('dashboard')
            ->name('dashboard.')
            ->group(base_path('routes/web/dashboard/auth.php'));

        Route::middleware(['web', 'auth:admin'])
            ->prefix('dashboard')
            ->name('dashboard.')
            ->group(base_path('routes/web/dashboard/dashboard.php'));
    })
    ->withMiddleware(function ($middleware) {

        // Redirect unauthenticated admin users to dashboard login
        $middleware->redirectGuestsTo(fn() => route('dashboard.login'));

        // Add no-cache middleware globally to prevent all caching issues
        $middleware->append(\App\Http\Middleware\NoCacheMiddleware::class);

        $middleware->alias([

            'localize'                => \Mcamara\LaravelLocalization\Middleware\LaravelLocalizationRoutes::class,
            'localizationRedirect'    => \Mcamara\LaravelLocalization\Middleware\LaravelLocalizationRedirectFilter::class,
            'localeSessionRedirect'   => \Mcamara\LaravelLocalization\Middleware\LocaleSessionRedirect::class,
            'localeCookieRedirect'    => \Mcamara\LaravelLocalization\Middleware\LocaleCookieRedirect::class,
            'localeViewPath'          => \Mcamara\LaravelLocalization\Middleware\LaravelLocalizationViewPath::class,
            'redirects'               => \App\Http\Middleware\RedirectsMiddleware::class,
            'lang.redirect'           => \App\Http\Middleware\LangRedirection::class,
            'secure.headers'          => \App\Http\Middleware\SecurityHeadersMiddleware::class,
            'no.cache'                => \App\Http\Middleware\NoCacheMiddleware::class,

        ]);
    })
    ->withExceptions(function ($exceptions) {
        // Handle exceptions here if needed
    })
    ->withCommands([
        \App\Console\Commands\SitemapGenerate::class,
        \App\Console\Commands\GenerateRobotsTxt::class,
    ])

    ->create();
