<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SecurityHeadersMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        $response->headers->set('X-Content-Type-Options', 'nosniff');
        $response->headers->set('X-Frame-Options', 'DENY');
        $response->headers->set('Referrer-Policy', 'no-referrer-when-downgrade');

        // HSTS only on HTTPS
        if ($request->isSecure()) {
            $response->headers->set('Strict-Transport-Security', 'max-age=31536000; includeSubDomains; preload');
        }

        // A permissive-but-safer CSP baseline (avoid breaking existing inline scripts/styles)
        $csp = "default-src 'self' https: data: 'unsafe-inline' 'unsafe-eval'";
        $response->headers->set('Content-Security-Policy', $csp);

        return $response;
    }
}


