<x-website.layout>

    <!-- start banner -->
    <section class="page-title centred">
        <div class="bg-layer" style="background-image: url({{ Path::imagesPath('background/banner.jpg') }});">
        </div>
        <div class="container">
            <div class="content-box">
                <ul class="bread-crumb clearfix">
                    <li><a href="../index.html">{{ __('website.home') }}</a></li>
                    <li>{{ $blog->name }}</li>
                </ul>
                <div class="title">
                    <h2>{{ $blog->name }}</h2>
                </div>
            </div>
        </div>
        <div class="media-partner">
            <ul class="media-links clearfix">
                <li>
                    <h6>{{ __('website.contact_us') }}</h6>
                </li>
                @foreach ($socialMediaLinks as $platform => $link)
                    @if ($link && $link != '#')
                        <li><a href="{{ $link }}" target="_blank" aria-label="{{ $platform }} Link"><i
                                    class="fab fa-{{ $platform }}"></i></a></li>
                    @endif
                @endforeach
            </ul>
        </div>
    </section>
    <!-- end banner -->
    <!-- start blog details -->
    <section class="services-details">
        <div class="container">
            <div class="row clearfix">
                <div class="col-lg-4 col-md-12 col-sm-12 order-lg-1 order-md-2 order-sm-2 sidebar-side">
                    <div class="services-sidebar">
                        <div class="sidebar-widget category-widget">
                            <div class="sec-title">
                                <h4 class="border-bottom">{{__('website.blogs')}}</h4>
                            </div>
                            <ul class="category-list clearfix">
                                @foreach ($blogs as $blogr)
                                    <li><a href="{{ $blogr->link }}">{{ $blogr->name }}</a></li>
                                @endforeach
                              
                            </ul>
                        </div>
                        <div class="sidebar-widget support-widget">
                            <div class="sec-title">
                                <h4 class="border-bottom">{{__('website.contact_us')}}</h4>
                            </div>
                            <div class="form-inner">
                                <x-website.partials.contact-form />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8 col-md-12 col-sm-12 order-lg-2 order-md-1 order-sm-1 content-side order-mob">
                    <div class="services-details-content">
                        <div class="content-one">
                            <div class="image-box"><img src="{{ $blog->image_path }}"
                                    alt="{{ $blog->name }}"></div>
                            <div class="lower-box mt-3">
                                <h1>{{ $blog->name }}</h1>
                                <div class="text">
                                    <p>{!! $blog->long_desc !!}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- end blog details -->
</x-website.layout>
