<!-- Mobile Offcanvas Menu -->
<div class="offcanvas offcanvas-end d-xl-none" id="mobileMenu" tabindex="-1" aria-labelledby="mobileMenuLabel">
    <div class="offcanvas-header">
        <a class="navbar-brand w-100" href="{{ Path::AppUrl('/') }}">
            <img src="{{ Path::AppLogo('site_logo') }}" alt="Xtremeblue Logo" width="100" />
        </a>
        <button type="button" class="btn btn-x" data-bs-dismiss="offcanvas" aria-label="Close">
            <i class="fa-solid fa-xmark fs-3"></i>
        </button>
    </div>

    <div class="offcanvas-body px-4">
        <ul class="navbar-nav gap-2">
            @if (isset($menus) && count($menus) > 0)
                @foreach ($menus as $menu)
                    @if ($menu->segment === 'products')
                        <li class="nav-item dropdown">
                            <a class="nav-link" href="#" id="galleryDropdown" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                {{ $menu->name }} <i class="fas fa-chevron-down"></i>
                            </a>

                            <ul class="dropdown-menu shadow-lg border-0 rounded-3">
                                @foreach ($products as $product)
                                    <li>
                                        <a class="dropdown-item d-flex align-items-center gap-2 fs-6"
                                            href="{{ $product->link }}">
                                            {{ $product->name }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </li>
                    @else
                        <li class="nav-item">
                            <a class="nav-link {{ request()->is(ltrim($menu->link, '/')) ? 'active' : '' }}"
                                href="{{ $menu->link }}">{{ $menu->name }}</a>
                        </li>
                    @endif
                @endforeach
            @endif
        </ul>

        <!-- Contact Info -->
        <ul class="list-unstyled list-contact px-2 pt-5 rounded-4">
            <li class="mb-4 pb-2 border-bottom">
                <div class="d-flex align-items-center gap-3 text-second">
                    <i class="fa-solid fa-envelope fs-5"></i>
                    <div>
                        <h5 class="fw-bold mb-1 text-main">@lang('website.email')</h5>
                        <a href="mailto: {{ config('settings.site_email') ?? '' }}"
                            class="text-decoration-none text-main">
                            {{ config('settings.site_email') ?? '' }}
                        </a>
                    </div>
                </div>
            </li>
            <li class="mb-4 pb-2 border-bottom">
                <div class="d-flex align-items-center gap-3">
                    <i class="fa-solid fa-phone-volume fs-5"></i>
                    <div>
                        <h5 class="fw-bold mb-1">@lang('website.phone')</h5>
                        <a href="tel:{{ $phones->firstWhere('type', 'phone')->code ?? '' }} {{ $phones->firstWhere('type', 'whatsapp')->phone ?? '' }}"
                            class=""> {{ $phones->firstWhere('type', 'whatsapp')->phone ?? '' }} </a>
                    </div>
                </div>
            </li>
            <li>
                <div class="d-flex align-items-center gap-3">
                    <i class="fa-solid fa-map-marker-alt fs-5"></i>
                    <div>
                        <h5 class="fw-bold mb-1">@lang('website.address')</h5>
                        <span class="d-block">
                            {{ $site_addresses[0]->address ?? '' }}
                        </span>
                    </div>
                </div>
            </li>

            <!-- Social Links -->
            <div class="d-flex gap-3 footer-social align-items-center mt-4">
                <a href="{{ $socialMediaLinks['facebook'] }}" target="_blank"><img
                        src="{{ Path::FrontImage('social/facebook.png') }}" height="35" alt=""></a>
                <a href="{{ $socialMediaLinks['instagram'] }}" target="_blank"><img
                        src="{{ Path::FrontImage('social/instagram.png') }}" height="40" alt=""></a>
                <a href="{{ $socialMediaLinks['linkedin'] }}" target="_blank"><img
                        src="{{ Path::FrontImage('social/linkedin.png') }}" height="35" alt=""></a>


            </div>
        </ul>
    </div>
</div>
<!-- End Mobile Menu -->
