



    @php
        $supportedLocales = config('laravellocalization.supportedLocales', []);
        $currentLocale = app()->getLocale();

        $flags = [
            'en' => '🇺🇸',
            'ar' => '🇸🇦',
            'fr' => '🇫🇷',
            'de' => '🇩🇪',
            'es' => '🇪🇸',
            'it' => '🇮🇹',
            'pt' => '🇵🇹',
            'ru' => '🇷🇺',
            'zh' => '🇨🇳',
            'ja' => '🇯🇵',
            'ko' => '🇰🇷',
            'tr' => '🇹🇷',
        ];
    @endphp

<header class="header">
    <nav class="navbar navbar-expand-xl">
        <div class="container">
            <!-- Logo -->
            <a class="navbar-brand" href="{{ Path::AppUrl('/') }}">
                <img src="{{ Path::AppLogo('site_logo') }}" alt="Xtremeblue logo" class="rounded-circle" />
            </a>
            <div class="d-flex align-items-center gap-2 d-xl-none">
                <!-- زر للداكن/الفاتح -->
                <button
                    class="themeToggle btn btn-send px-3 rounded-circle d-flex justify-content-center align-items-center"
                    style="width: 45px; height: 45px">
                    <i class="themeIcon fa-solid fa-sun"></i>
                </button>

                <div class="">
                    @foreach ($supportedLocales as $code => $language)
                        @if ($code !== $currentLocale)
                            <a href="{{ \App\Helpers\LocalizationHelper::getCurrentPageLocalizedUrl($code) }}"
                                class="btn btn-send"> {{ $flags[$code] ?? '🌐' }} {{ $language['native'] }}</a>
                        @endif
                    @endforeach
                </div>
                <!-- زر الدارك مود -->
                <!-- Mobile Toggle -->
                <button class="navbar-toggler shadow-none border-0" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#mobileMenu" aria-controls="mobileMenu" aria-label="Toggle navigation">
                    <i class="fa-solid fa-bars fs-3"></i>
                </button>
            </div>

            <!-- Desktop Menu -->
            <x-website.partials.mainmenu :menus="$menus" :supportedLocales="$supportedLocales" />

        </div>

        <!-- Mobile Offcanvas Menu -->
             <x-website.partials.mobilemenu :menus="$menus" />
    </nav>
</header>
