<!-- SEO Component - This includes all meta tags, title, hreflang, and schema -->
@if (isset($metatags) && isset($schema))
    <x-seo.head :metatags="$metatags" :schema="$schema" />
@else
    {{-- Basic SEO for pages without metatags --}}
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Language" content="{{ app()->getLocale() }}">
    <meta name="robots" content="index, follow">
    <meta name="description"
        content="{{ config('settings.site_description')  }}">
    <meta name="author" content="{{ config('settings.site_name') }}">
    <title>{{ config('settings.site_name')  }}</title>

    {{-- Security Headers --}}
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    {{-- <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests"> --}}
    <meta http-equiv="Strict-Transport-Security" content="max-age=31536000; includeSubDomains; preload">

    {{-- Canonical URL --}}
    <link rel="canonical" href="{{ url()->current() }}">

    {{-- Favicon --}}
    <link rel="icon" href="{{ \App\Helper\Path::FavIcon() }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('favicon.png') }}" type="image/png">
    <link rel="apple-touch-icon" href="{{ asset('favicon.png') }}">

    {{-- PWA Manifest --}}
    <link rel="manifest" href="{{ route('manifest') }}?v={{ time() }}">

    {{-- PWA Meta Tags --}}
    <meta name="theme-color" content="#007bff">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="{{ config('settings.site_name')  }}">
    <meta name="msapplication-TileColor" content="#007bff">
    <meta name="msapplication-tap-highlight" content="no">

    {{-- Apple Touch Icons --}}
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="152x152" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="144x144" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="120x120" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="114x114" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="76x76" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="72x72" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="60x60" href="{{ asset('favicon.png') }}">
    <link rel="apple-touch-icon" sizes="57x57" href="{{ asset('favicon.png') }}">

    {{-- Microsoft Tiles --}}
    <meta name="msapplication-TileImage" content="{{ asset('favicon.png') }}">
    <meta name="msapplication-config" content="{{ asset('browserconfig.xml') }}">

    {{-- Open Graph --}}
    <meta property="og:title" content="{{ config('settings.site_name') }}">
    <meta property="og:description"
        content="{{ config('settings.site_description') }}">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:image" content="{{ asset('assets/website/images/og-image.jpg') }}">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="{{ config('settings.site_name') }}">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="{{ config('settings.site_name')  }}">
    <meta property="og:locale" content="{{ app()->getLocale() }}">
    <meta property="og:locale:alternate" content="{{ app()->getLocale() == 'en' ? 'ar' : 'en' }}">

    {{-- Twitter --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ config('settings.site_name')  }}">
    <meta name="twitter:description"
        content="{{ config('settings.site_description') }}">
    <meta name="twitter:image" content="{{ asset('assets/website/images/og-image.jpg') }}">
    <meta name="twitter:url" content="{{ url()->current() }}">
    <meta name="twitter:site" content="@mibicom">
    <meta name="twitter:creator" content="@mibicom">

    {{-- Performance --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="dns-prefetch" href="//www.google-analytics.com">
    <link rel="dns-prefetch" href="//www.googletagmanager.com">

    {{-- Hreflang Tags --}}
    @php
        $locales = ['ar', 'en'];
        $currentPath = request()->path();
        $pathWithoutLocale = preg_replace('/^(ar|en)\/?/', '', $currentPath);

        // Check if this is a blog page
        if (preg_match('/^blogs\/(.+)$/', $pathWithoutLocale, $matches)) {
            $currentSlug = urldecode($matches[1]);

            // Try multiple methods to find the blog
            $blog = \App\Models\Blog::whereRaw("JSON_EXTRACT(slug, '$.ar') = ?", [$currentSlug])
                ->orWhereRaw("JSON_EXTRACT(slug, '$.en') = ?", [$currentSlug])
                ->first();

            // If not found with JSON_EXTRACT, try manual search
            if (!$blog) {
                $blogs = \App\Models\Blog::all();
                foreach ($blogs as $b) {
                    foreach (['ar', 'en'] as $lang) {
                        $blogSlug = $b->getTranslation('slug', $lang);
                        if ($blogSlug === $currentSlug) {
                            $blog = $b;
                            break 2;
                        }
                    }
                }
            }

            if ($blog) {
                foreach ($locales as $locale) {
                    $localizedUrl = $blog->getLocalizedUrl($locale);
                    if ($localizedUrl) {
                        echo '<link rel="alternate" hreflang="' . $locale . '" href="' . $localizedUrl . '" />';
                    }
                }
                // Add x-default pointing to Arabic (default language)
                $defaultUrl = $blog->getLocalizedUrl('ar');
                if ($defaultUrl) {
                    echo '<link rel="alternate" hreflang="x-default" href="' . $defaultUrl . '" />';
                }
            } else {
                // Fallback to simple method if blog not found
                $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
                foreach ($locales as $locale) {
                    echo '<link rel="alternate" hreflang="' .
                        $locale .
                        '" href="' .
                        url('/' . $locale . $path) .
                        '" />';
                }
                // Add x-default pointing to Arabic
                echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />';
            }
        } else {
            // For non-blog pages, use the simple method
            $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
            foreach ($locales as $locale) {
                echo '<link rel="alternate" hreflang="' . $locale . '" href="' . url('/' . $locale . $path) . '" />';
            }
            // Add x-default pointing to Arabic
            echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />';
        }
    @endphp

    {{-- Schema.org --}}
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "{{ config('settings.site_name')  }}",
        "url": "{{ url('/') }}",
        "logo": "{{ asset('assets/website/images/logo.png') }}",
        "description": "{{ config('settings.site_description') ?? 'خدمات تطوير الويب والحلول الرقمية المتكاملة' }}",
        "sameAs": [
            "https://www.facebook.com/mibicom",
            "https://x.com/mibicom",
            "https://www.linkedin.com/company/mibicom",
            "https://www.instagram.com/mibicom",
            "https://www.youtube.com/@mibicom"
        ]
    }
    </script>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebSite",
        "name": "{{ config('settings.site_name')  }}",
        "url": "{{ url('/') }}",
        "potentialAction": {
            "@type": "SearchAction",
            "target": "{{ url('/') }}?q={search_term_string}",
            "query-input": "required name=search_term_string"
        }
    }
    </script>
@endif



<!-- ======== CSS & Google Fonts ============ -->
<!-- Google Fonts -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&display=swap" rel="stylesheet">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

@php
    $currentLocale = app()->getLocale();
    $isRTL = in_array($currentLocale, ['ar', 'he', 'fa', 'ur']); // RTL languages
    $textDirection = $isRTL ? 'rtl' : 'ltr';
@endphp

{{-- Set HTML lang and dir attributes --}}
<script>
    document.documentElement.setAttribute('lang', '{{ $currentLocale }}');
    document.documentElement.setAttribute('dir', '{{ $textDirection }}');
</script>


<!-- ======== CSS & Google Fonts ============ -->
 <!-- files css -->
    <link rel="stylesheet" href="{{ Path::css('all.min.css') }}" />
    <link rel="stylesheet" href="{{ Path::css('bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ Path::css('animate.css') }}" />
    <link rel="stylesheet" href="{{ Path::css('owl.carousel.min.css') }}" />
    <link rel="stylesheet" href="{{ Path::css('owl.theme.default.min.css') }}" />
    <link rel="stylesheet" href="{{ Path::css('style.css') }}" />
    <link rel="stylesheet" href="{{ Path::css('media.css') }}" />
    <!-- google font  -->
