{{-- Schema JSON-LD --}}
@if (!empty($schema))
    <script type="application/ld+json">
{!! json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@else
    {{-- Default WebPage Schema (safe encoding) --}}
    @php
        // Use the same canonical URL logic for schema
        $currentUrl = url()->current();
        $schemaUrl = $currentUrl;

        // Remove language prefix if it exists
        if (app()->getLocale() !== config('app.fallback_locale')) {
            $localePrefix = '/' . app()->getLocale();
            if (str_starts_with($currentUrl, $localePrefix)) {
                $schemaUrl = str_replace($localePrefix, '', $currentUrl);
            }
        }

        $schemaUrl = rtrim($schemaUrl, '/');
        if (empty($schemaUrl)) {
            $schemaUrl = url('/');
        }
    @endphp
    <script type="application/ld+json">
{!! json_encode([
        '@context' => 'https://schema.org',
        '@type' => 'WebPage',
        'name' => $metatags['title'] ?? config('settings.site_name'),
        'url' => $metatags['canonical'] ?? $schemaUrl,
        'description' => $metatags['description'] ?? ''
    ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- FAQ Schema --}}
@if (!empty($faq_schema))
    <script type="application/ld+json">
    {!! json_encode($faq_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif

{{-- Breadcrumb Schema --}}
@if (!empty($breadcrumb_schema))
    <script type="application/ld+json">
    {!! json_encode($breadcrumb_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endif





{{-- Default Schema for Organization and Website --}}
@if (empty($schema))
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "{{ config('settings.site_name') ?? '' }}",
        "url": "{{ url('/') }}",
        "logo": "{{ asset('assets/website/images/logo.png') }}",
        "description": "{{ config('settings.site_description') ?? '' }}",
        "sameAs": [
            "https://www.facebook.com/mibicom",
            "https://x.com/mibicom",
            "https://www.linkedin.com/company/mibicom",
            "https://www.instagram.com/mibicom",
            "https://www.youtube.com/@mibicom"
        ]
    }
    </script>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebSite",
        "name": "{{ config('settings.site_name') ?? '' }}",
        "url": "{{ url('/') }}",
        "potentialAction": {
            "@type": "SearchAction",
            "target": "{{ url('/') }}?q={search_term_string}",
            "query-input": "required name=search_term_string"
        }
    }
    </script>
@endif
