<x-website.layout>

    <!-- start banner -->
    @foreach ($sections as $section)
        @if ($section->key == 'projects')
            @include('Website.partials._banner', ['banner' => $section])
            @break
        @endif
    @endforeach

   <section class="capabilities-section py-5 wow fadeInUp" data-wow-delay="0.2s">

    <div class="container py-5">
      @foreach ($sections as $section)
        @if ($section->key == 'projects')
            <div class="text-center mb-5">
              <h2 class="fw-bold">{{ $section->sconde_title }}</h2>
              <p class="">{{ $section->short_desc }}</p>
            </div>
           @break
        @endif
    @endforeach
      
  
      <ul class="list-unstyled about-list">
        <!-- Raw Materials -->
        @foreach ($projects as $project)
                    <li class="mb-5 wow fadeInUp border-bottom pb-5" data-wow-delay="0.3s">
          <h3 class="mb-3">{{$project->name}}</h3>
          <p>
           {!! $project->long_desc !!}
          </p>
          <img
            src="{{$project->image_path}}"
            alt="Raw Materials"
            class="w-100 rounded-4 shadow mt-3 object-fit-cover"
            height="250"
          />
        </li>
            
        @endforeach

      </ul>
  
    </div>

  
</section>

</x-website.layout>
