<x-website.layout>
    <!-- start banner -->
    @foreach ($sections as $section)
        @if ($section->key == 'products')
            @include('Website.partials._banner', ['banner' => $section])
        @endif
    @endforeach
    <!-- end banner -->
    <section class="py-5">
        <div class="container py-4">

            <!-- Nav Tabs -->
            <ul class="nav nav-pills justify-content-center mb-4 custom-nav-pills" id="companiesTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="all-tab" data-bs-toggle="tab" data-bs-target="#all"
                        type="button" role="tab">
                        @lang('website.all_companies')
                    </button>
                </li>
                @foreach ($suppliers as $key => $supplier)
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="subb{{ $supplier->logo }}" data-bs-toggle="tab"
                            data-bs-target="#sub{{ $key }}" type="button" role="tab">
                            {{ $supplier->name }}
                        </button>
                    </li>
                @endforeach


            </ul>

            <!-- Tab Content -->
            <div class="tab-content" id="companiesTabContent">
                <div class="tab-pane fade show active" id="all" role="tabpanel" aria-labelledby="all-tab">
                    <div class="row g-3">
                        @foreach ( $productsD as $productD)
                            <div class="col-md-4 col-lg-3">
                                <div class="card product-card-details  shadow-sm">
                                    <div class="card-body">
                                        <h6 class="fw-bold mb-1">{{$productD->name}}</h6>
                                        <p class="small mb-2">{!! $productD->short_desc !!}</p>
                                        <span class="badge bg-light second-color mb-3">{{$productD->partner?->name}}</span>
                                        <a href="{{Path::AppUrl('contact-us')}}" class="btn btn-send w-100 fw-bold">@lang('website.add_to_quote')</a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                @foreach ($suppliers as $key => $subplier)
                    <div class="tab-pane fade" id="sub{{ $key }}" role="tabpanel" aria-labelledby="all-tab">
                        <div class="row g-3">
                           @foreach ( $subplier->products as $productD)
                                <div class="col-md-4 col-lg-3">
                                    <div class="card product-card-details  shadow-sm">
                                        <div class="card-body">
                                            <h6 class="fw-bold mb-1">{{$productD->name}}</h6>
                                            <p class="small mb-2">{!! $productD->short_desc !!}</p>
                                            <span class="badge bg-light second-color mb-3">{{$productD->partner?->name}}</span>
                                            <a href="{{Path::AppUrl('contact-us')}}" class="btn btn-send w-100 fw-bold">@lang('website.add_to_quote')</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                         
                        </div>
                    </div>
                @endforeach

                <!-- باقي التبويبات -->
            </div>
        </div>
    </section>

</x-website.layout>
