<section class="contact-section">
    <div class="container">
        <div class="row clearfix">
            <div class="col-lg-5 col-md-12 col-sm-12 content-column">
                <div class="content_block_six">
                    <div class="content-box">
                        @foreach ($sections as $section)
                            @if ($section->key == 'contact')
                                <div class="sec-title">
                                    <span class="sub-title">{{ $section->name }}</span>
                                    <h2>{{ $section->title }}</h2>
                                </div>
                            @endif
                        @endforeach
                        <div class="inner-box">
                            <div class="single-item">
                                <div class="icon-box"><i class="fa fa-envelope"></i></div>
                                <p>{{ __('website.email') }}</p>
                                <h3><a href="mailto:{{ config('settings.site_email') }}"
                                        aria-label="contact">{{ config('settings.site_email') }}</a></h3>
                            </div>
                            <div class="single-item">
                                <div class="icon-box"><i class="fa fa-phone"></i></div>
                                <p>{{ __('website.call_us') }}</p>
                                @foreach ($phones as $phone)
                                    @if ($phone->type == 'phone')
                                        <h3><a href="tel:{{ $phone->code }}{{ $phone->phone }}" aria-label="phone">
                                                <i class="fas fa-phone"></i> {{ $phone->code }}{{ $phone->phone }}
                                            </a></h3>
                                    @elseif($phone->type == 'whatsapp')
                                        <h3><a href="https://wa.me/{{ $phone->code }}{{ $phone->phone }}"
                                                aria-label="whatsapp" target="_blank">
                                                <i class="fab fa-whatsapp"></i> {{ $phone->code }}{{ $phone->phone }}
                                            </a></h3>
                                    @endif
                                @endforeach
                            </div>
                            @foreach ($site_addresses as $address)
                                <div class="single-item">
                                    <div class="icon-box"><i class="fa fa-map-marked-alt"></i></div>
                                    <p>{{ $address->title }}</p>

                                    <h3><a href="{{ $address->map_link }}" target="_blank"
                                            aria-label="map">{{ $address->address }}</a></h3>

                                </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-7 col-md-12 col-sm-12 form-column">
                <div class="form-inner">
                    <x-website.partials.contact-form />

                </div>
            </div>
        </div>
    </div>
</section>
<!-- <======================= EndContactForm =========================> -->
