@if ($blogs->isNotEmpty())
    <!--===============Blogs==============-->
    <section class="news-section sec-pad pt-5">
        <div class="container">
            @foreach ($sections as $section)
                @if ($section->key == 'blogs')
                    <div class="sec-title">
                        <span class="sub-title">{{ $section->name }}</span>
                        <h2 class="border-bottom">{{ $section->title }}</h2>
                @endif
            @endforeach
        </div>
        <div class="row clearfix">
            @foreach ($blogs as $blog)
                <div class="col-lg-4 col-md-6 col-sm-12 news-block">
                    <div class="news-block-one">
                        <div class="inner-box">
                            <figure class="image-box">
                                <a href="{{ $blog->link }}" aria-label="blogs">
                                    <div class="img-div lazy-div">
                                        <img class="lazy img" data-src="{{ $blog->image_path }}"
                                            data-srcset="{{ $blog->image_path }}" alt="{{ $blog->name }}"
                                            width="350" height="250">
                                        <div class="next-lazy-img"></div>
                                </a>
                            </figure>
                            <div class="lower-content">
                                <h3><a href="{{ $blog->link }}" aria-label="title">{{ $blog->name }}</a></h3>
                                <p>{{ \Illuminate\Support\Str::limit(strip_tags((string) $blog->short_desc), 100) }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
            <div class="col-12 mt-5 centred">
                <div class="btn-box">
                    <a href="{{ Path::AppUrl('blogs') }}" class="theme-btn btn-one"
                        aria-label="homeBlogs">{{ __('website.all_blogs') }}</a>
                </div>
            </div>
        </div>
        </div>
    </section>
    <!--===============Blogs==============-->
@endif
