<x-website.layout>
    <!-- start banner -->
    @foreach ($sections as $section)
        @if ($section->key == 'contact')
            @include('Website.partials._banner', ['section' => $section])
        @endif
    @endforeach
    <!-- end banner -->
    <!-- end banner -->


        <section class="contact-section py-5 wow fadeInUp" data-wow-delay="0.2s">
  <div class="container py-5">
    <div class="row g-5">
      <!-- Left Section -->
      <div class="col-lg-6 contact-form d-flex align-items-center gap-3 wow fadeInLeft" data-wow-delay="0.4s">
        <div class="w-100  bg-white p-4 rounded-5 shadow">
          <h1 class="mb-3 fw-bold main-color wow fadeInDown" data-wow-delay="0.6s">
            @lang('website.Get in touch with us')
          </h1>
          <p class="text-muted wow fadeIn" data-wow-delay="0.8s">@lang('website.Contact us')</p>
       
            <x-website.partials.contact-form :products="$products" />
        </div>
      </div>

      <!-- Right Section -->
      <div class="col-lg-6 contact-info d-flex flex-column justify-content-center wow fadeInRight" data-wow-delay="0.6s">
        <div class="h-50">
          <div class="d-flex align-items-start mb-4 wow fadeInUp" data-wow-delay="0.8s">
            <div class="icon-box bg-white main-color shadow">
              <i class="fa fa-phone"></i>
            </div>
            <div>
              <h4 class="fw-semibold fs-5">@lang('website.phone')</h4>
                @foreach ($phones as $phone)
                     @if ($phone->type == 'phone')
                        <p class="mb-0 "> <a href="tel:{{$phone->code}}" target="_blank">{{$phone->phone}}</a> </p>
                        @break
                    @endif
                @endforeach
            </div>
          </div>

          <div class="d-flex align-items-start mb-4 wow fadeInUp" data-wow-delay="1s">
            <div class="icon-box bg-white main-color shadow">
              <i class="fa fa-envelope"></i>
            </div>
            <div>
              <h4 class="fw-semibold fs-5">@lang('website.email_address')</h4>
              <p class="mb-0 "> <a href="mailto:{{config('setting.site_email')}}"> {{ config('setting.site_email') }} </a> </p>
            </div>
          </div>

          <div class="d-flex align-items-start wow fadeInUp" data-wow-delay="1.2s">
            <div class="icon-box bg-white main-color shadow">
              <i class="fa fa-map-marker-alt"></i>
            </div>
            <div>
                @foreach ($site_addresses as $address)
                    <h4 class="fw-semibold fs-5">@lang('website.address')</h4>
                    <p class="mb-0 "> <a href="{{ $address->map_link }}" target="_blank"></a> {{ $address->address }}</p>
                    @break
                @endforeach
            </div>
          </div>
        </div>

        <!-- Map -->
        @foreach ($site_addresses as $address)
        <div class="map-wrapper position-relative rounded-5 overflow-hidden h-100 wow fadeInUp" data-wow-delay="1.4s" style="height:400px !important;">
          <iframe src="{{ $address->map_url }}" 
            width="100%" height="100%" loading="lazy"></iframe>
          <div class="map-overlay">
            <div class="pin">
              <i class="fa fa-map-pin"></i>
            </div>
          </div>
        </div>
        @break
        @endforeach

      </div>
    </div>
  </div>
</section>

    <!-- end map -->
</x-website.layout>
