<x-dashboard.layout :title="__('dashboard.edit') . ' ' . $team->name_en">

    <!-- Page Header -->
    <x-dashboard.partials.page-header 
        :header="__('dashboard.edit') . ' ' . $team->name_en"
        :label_url="route('dashboard.teams.index')" 
        :label="__('dashboard.teams')" />
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-header">
                    <h4 class="card-title">{{ __('dashboard.edit') . ' ' . $team->name_en }}</h4>
                </div>

                <div class="card-body">

                    <form action="{{ route('dashboard.teams.update', $team->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PATCH')
                        <div class="row">

                            <!-- Name Arabic / English -->
                            <x-dashboard.multilingual-input name="name" type="text" :required="true" :model="$team" />

                            <!-- Position Arabic / English -->
                            <x-dashboard.multilingual-input name="position" type="text" :required="true" :model="$team" />

                            <!-- Social Links -->
                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.facebook') }}</label>
                                <input type="url" class="form-control" name="facebook" placeholder="https://facebook.com/..."
                                    value="{{ old('facebook', $team->facebook) }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.twitter') }}</label>
                                <input type="url" class="form-control" name="twitter" placeholder="https://twitter.com/..."
                                    value="{{ old('twitter', $team->twitter) }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.instagram') }}</label>
                                <input type="url" class="form-control" name="instagram" placeholder="https://instagram.com/..."
                                    value="{{ old('instagram', $team->instagram) }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.tiktok') }}</label>
                                <input type="url" class="form-control" name="tiktok" placeholder="https://tiktok.com/..."
                                    value="{{ old('tiktok', $team->tiktok) }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label>{{ __('dashboard.youtube') }}</label>
                                <input type="url" class="form-control" name="youtube" placeholder="https://youtube.com/..."
                                    value="{{ old('youtube', $team->youtube) }}">
                            </div>

                            <!-- Image Upload -->
                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.image') }} (max 2MB)</label>
                                <input type="file" class="form-control" name="image" accept="image/*">
                            </div>

                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.current_image') }}</label><br>
                                 <img src="{{ $team->image_path }}" width="250" class="img-thumbnail">
                      
                            </div>

                            <!-- Alt Image -->
                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.alt_image') }}</label>
                                <input class="form-control" name="alt_image" type="text"
                                    placeholder="{{ __('dashboard.alt_image') }}"
                                    value="{{ old('alt_image', $team->alt_image) }}">
                            </div>

                            <!-- Status -->
                            <div class="form-group col-md-4 mt-3 mb-3">
                                <div class="d-flex flex-wrap gap-2">
                                    <h5 class="font-size-14 mb-3">{{ __('dashboard.publish/unpublish') }}</h5>
                                    <input type="checkbox" id="switch1" switch="none" value="1" name="status"
                                        @checked(old('status', $team->status)) />
                                    <label for="switch1" data-on-label="{{ __('dashboard.yes') }}"
                                        data-off-label="{{ __('dashboard.no') }}"></label>
                                </div>
                            </div>

                            <!-- Submit Buttons -->
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{ __('dashboard.update') }}
                                </button>
                                <a href="{{ route('dashboard.teams.index') }}" class="btn btn-danger">
                                    <i class="icon-trash"></i> {{ __('dashboard.cancel') }}
                                </a>
                            </div>

                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

</x-dashboard.layout>
