<x-dashboard.layout :title="__('dashboard.features')">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">{{ __('dashboard.features') }}</h4>

                    <div class="page-title-right d-flex align-items-center">
                        <div class="btn btn-list">
                            <a href="{{ route('dashboard.features.create') }}" class="btn ripple btn-primary">
                                <i class="fas fa-plus-circle"></i> {{ __('dashboard.add') }}
                            </a>
                            <button id="btn_active" class="btn ripple btn-dark">
                                <i class="fas fa-eye"></i> {{ __('dashboard.publish/unpublish') }}
                            </button>
                            <button id="btn_delete" class="btn ripple btn-danger">
                                <i class="fas fa-trash"></i> {{ __('dashboard.delete') }}
                            </button>
                        </div>

                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ __('dashboard.features') }}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Table -->
        <div class="row">
            <div class="col-12">
                <div class="dashboard-table-container">
                    <div class="card-header">
                        <h4>{{ __('dashboard.features') }}</h4>
                    </div>
                    <div class="card-body">
                        <table id="datatable-features" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 50px;">
                                        <input type="checkbox" id="checkAll" class="form-check-input">
                                    </th>
                                    <th>{{ __('dashboard.id') }}</th>
                                    <th>{{ __('dashboard.title_en') }}</th>
                                    <th>{{ __('dashboard.title_ar') }}</th>
                                    <th>{{ __('dashboard.counter') }}</th>
                                    <th>{{ __('dashboard.icon') }}</th>
                                    <th>{{ __('dashboard.status') }}</th>
                                    <th>{{ __('dashboard.actions') }}</th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach ($features as $feature)
                                    <tr id="{{ $feature->id }}">
                                        <td class="text-center">
                                            <input type="checkbox" class="check-inputs form-check-input"
                                                value="{{ $feature->id }}">
                                        </td>
                                        <td><a href="{{ route('dashboard.features.edit', $feature->id) }}">{{ $feature->id }}</a></td>
                                        <td><a href="{{ route('dashboard.features.edit', $feature->id) }}">
                                            {{ $feature->getTranslation('title', 'en') }}
                                        </a></td>
                                        <td><a href="{{ route('dashboard.features.edit', $feature->id) }}">
                                            {{ $feature->getTranslation('title', 'ar') }}
                                        </a></td>
                                        <td>{{ $feature->counter }}</td>
                                        <td>
                                           @if ($feature->icon)
                                                <img src="{{ $feature->icon_path }}" 
                                                    alt="icon" width="40" height="40"
                                                    class="rounded shadow-sm object-fit-cover">
                                            @else
                                                <span class="text-muted">—</span>
                                            @endif

                                        </td>
                                        <td>
                                            @if ($feature->status)
                                                <span class="badge bg-success">{{ __('dashboard.yes') }}</span>
                                            @else
                                                <span class="badge bg-danger">{{ __('dashboard.no') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('dashboard.features.edit', $feature->id) }}"
                                                class="btn btn-sm btn-primary" title="{{ __('dashboard.edit') }}">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('dashboard.features.destroy', $feature->id) }}"
                                                method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger"
                                                    title="{{ __('dashboard.delete') }}"
                                                    onclick="return confirm('{{ __('dashboard.confirm_delete') }}')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div>

    @push('scripts')
        <script>
            $(document).ready(function() {
                // initialize DataTable
                if (!$.fn.DataTable.isDataTable('#datatable-features')) {
                    $('#datatable-features').DataTable({
                        "responsive": true,
                        "autoWidth": false,
                        "pageLength": 25,
                        "language": {
                            "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
                        }
                    });
                }

                // select all checkboxes
                $('#checkAll').on('click', function() {
                    $('.check-inputs').prop('checked', this.checked);
                });

                $('.check-inputs').on('click', function() {
                    var totalCheckboxes = $('.check-inputs').length;
                    var checkedCheckboxes = $('.check-inputs:checked').length;
                    $('#checkAll').prop('checked', totalCheckboxes === checkedCheckboxes);
                });
            });
        </script>
    @endpush
</x-dashboard.layout>
