<x-dashboard.layout :title="__('dashboard.edit_feature')">

    <x-dashboard.partials.page-header 
        :header="__('dashboard.edit_feature')" 
        :label_url="route('dashboard.features.index')" 
        :label="__('dashboard.features')" />

    <div class="card custom-card">
        <div class="card-body">
            <form action="{{ route('dashboard.features.update', $feature->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row">

                    <x-dashboard.multilingual-input name="title" type="text" :model="$feature" />
                    <x-dashboard.multilingual-input name="text" type="textarea" rows="4" :model="$feature" />

                    <div class="form-group col-md-4">
                        <label>{{ __('dashboard.counter') }}</label>
                        <input type="text" name="counter" class="form-control" value="{{ old('counter', $feature->counter) }}">
                    </div>

                    <div class="form-group col-md-4">
                        <label>{{ __('dashboard.icon') }} (image)</label>
                        <input type="file" name="icon" class="form-control" accept="image/*">

                        @if ($feature->icon)
                            <div class="mt-2">
                                <img src="{{ $feature->icon_path}}" alt="icon" width="80" class="rounded shadow">
                            </div>
                        @endif
                    </div>

                    <div class="form-group col-md-12 mt-3">
                        <button type="submit" class="btn btn-success">
                            <i class="icon-note"></i> {{ __('dashboard.update') }}
                        </button>
                        <a href="{{ route('dashboard.features.index') }}" class="btn btn-danger">
                            <i class="icon-trash"></i> {{ __('dashboard.cancel') }}
                        </a>
                    </div>

                </div>
            </form>
        </div>
    </div>

</x-dashboard.layout>
