<x-dashboard.layout :title="__('dashboard.add_feature')">

    <x-dashboard.partials.page-header 
        :header="__('dashboard.add_feature')" 
        :label_url="route('dashboard.features.index')" 
        :label="__('dashboard.features')" />

    <div class="card custom-card">
        <div class="card-body">
            <form action="{{ route('dashboard.features.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">

                    <x-dashboard.multilingual-input name="title" type="text" :required="true" />
                    <x-dashboard.multilingual-input name="text" type="textarea" rows="4" :required="true" />

                    <div class="form-group col-md-4">
                        <label>{{ __('dashboard.counter') }}</label>
                        <input type="text" name="counter" class="form-control" value="{{ old('counter') }}">
                    </div>

                    <div class="form-group col-md-4">
                        <label>{{ __('dashboard.icon') }} (image)</label>
                        <input type="file" name="icon" class="form-control" accept="image/*">
                    </div>

                    <div class="form-group col-md-12 mt-3">
                        <button type="submit" class="btn btn-success">
                            <i class="icon-note"></i> {{ __('dashboard.save') }}
                        </button>
                        <a href="{{ route('dashboard.features.index') }}" class="btn btn-danger">
                            <i class="icon-trash"></i> {{ __('dashboard.cancel') }}
                        </a>
                    </div>

                </div>
            </form>
        </div>
    </div>

</x-dashboard.layout>
