(function ($) {
    "use strict";
    function loader() {
      $(window).on("load", function () {
        $(".loading").addClass("loaded");
        $(".loading").delay(600).fadeOut();
      });
    }
  
    loader();
  })(jQuery);
  
  
  let nav = document.querySelector(".navbar");
  let navHeight = nav.offsetHeight;
  
  window.addEventListener("scroll", function () {
    let scrollTop = window.scrollY;
    
    if (scrollTop > navHeight) {
      nav.classList.add("fixed-top");
  
    } else {
  
      nav.classList.remove("fixed-top");
    }
  });


  // Enhanced Hero Slider
  var owl = $(".hero");
  owl.owlCarousel({
    items: 1,
    loop: true,
    margin: 50,
    autoplay: true,
    rtl: true,
    nav: false,
    dots: false,
    autoplayTimeout: 4000,
    animateIn: 'fadeIn',
    animateOut: 'fadeOut'
  });
  
  $(document).ready(function(){
    $(".product-owl").owlCarousel({
      loop:true,
      margin:20,
      nav:true,
      rtl: true,
      dots:true,
      autoplay:true,
      autoplayTimeout:2500,
      responsive:{
        0:{ items:1 },
        768:{ items:1 },
        992:{ items:1 },
        1200:{items:2}
      }
    });
  });
  $(document).ready(function () {
    // الكاروسيل الأول (عادي)
    $(".suppliers-1").owlCarousel({
      loop: true,
      margin: 20,
      rtl: true,
      dots:false,
      autoplayTimeout: 0,        // بدون توقف
      autoplaySpeed: 6000,       // سرعة الانزلاق
      slideTransition: "linear", 
      autoplayHoverPause: false,
      responsive: {
        0: { items: 2 },
        576: { items: 3 },
        768: { items: 4 },
        992: { items: 6 }
      }
    });
  
    // الكاروسيل الثاني (عكسي)
    $(".suppliers-2").owlCarousel({
      loop: true,
      margin: 20,
      dots:false,
      rtl: true, // الحركة عكسية
      autoplayTimeout: 0,        // بدون توقف
      autoplaySpeed: 6000,       // سرعة الانزلاق
      slideTransition: "linear", 
      autoplayHoverPause: false,
      responsive: {
        0: { items: 2 },
        576: { items: 3 },
        768: { items: 4 },
        992: { items: 6 }
      }
    });
  });
  setInterval(() => {
    $(".suppliers-2").trigger("prev.owl.carousel");
  }, 3000);
  setInterval(() => {
    $(".suppliers-1").trigger("next.owl.carousel");
  }, 3000);
  
  document.addEventListener("DOMContentLoaded", () => {
    const docEl = document.documentElement;
    const toggleBtns = document.querySelectorAll(".themeToggle");
    const icons = document.querySelectorAll(".themeIcon");
  
    // ضبط الحالة حسب localStorage
    const setLight = () => {
      docEl.setAttribute("data-theme", "light");
      icons.forEach(icon => {
        icon.classList.remove("fa-sun");
        icon.classList.add("fa-moon");
      });
    };
    const setDark = () => {
      docEl.removeAttribute("data-theme");
      icons.forEach(icon => {
        icon.classList.remove("fa-moon");
        icon.classList.add("fa-sun");
      });
    };
  
    const stored = localStorage.getItem("theme");
    if (stored === "light") setLight();
    else setDark();
  
    toggleBtns.forEach(btn => {
      btn.addEventListener("click", () => {
        if (docEl.getAttribute("data-theme") === "light") {
          setDark();
          localStorage.setItem("theme", "dark");
        } else {
          setLight();
          localStorage.setItem("theme", "light");
        }
      });
    });
  });
  
  
  
  
  

  // Back To Top Slider
document.addEventListener("DOMContentLoaded", function () {
  const backTopButton = document.getElementById("back-top");

  // Show/hide button on scroll
  window.addEventListener("scroll", function () {
    if (window.scrollY > 20) {
      backTopButton.classList.add("show");
    } else {
      backTopButton.classList.remove("show");
    }
  });

  // Scroll to top when clicked
  backTopButton.addEventListener("click", function (e) {
    e.preventDefault();
    window.scrollTo({
      top: 0,
      behavior: "smooth",
    });
  });
});

let toggle = document.getElementById("galleryDropdown");
let menu = document.querySelector(".dropdown-menu");

toggle.addEventListener("click", function (e) {
  // اشتغل بالضغط فقط لو العرض أقل من 992px (موبايل/تابلت)
  if (window.innerWidth < 992) {
    e.preventDefault();
    menu.classList.toggle("show");
  }
});






 
//   document.addEventListener("DOMContentLoaded", () => {
//     const counters = document.querySelectorAll(".counter");
//     let started = false; // ضمان العد مرة واحدة
  
//     const startCounting = () => {
//       counters.forEach(counter => {
//         let count = 0;
//         const target = +counter.dataset.target;
//         const increment = target / 200; // كلما قل الرقم زادت السرعة
  
//         const updateCount = () => {
//           count += increment;
//           if (count >= target) {
//             counter.textContent = `+${target}`;
//           } else {
//             counter.textContent = `+${Math.floor(count)}`;
//             requestAnimationFrame(updateCount); // سلاسة أفضل من setInterval
//           }
//         };
  
//         updateCount();
//       });
//     };
  
//     // استخدام IntersectionObserver لمراقبة السكشن
//     const section = document.querySelector(".stats");
//     const observer = new IntersectionObserver((entries) => {
//       if (entries[0].isIntersecting && !started) {
//         started = true;
//         startCounting();
//         observer.disconnect(); // إيقاف المراقبة بعد التفعيل
//       }
//     }, { threshold: 0.3 });
  
//     observer.observe(section);
//   });
  
  