<?php

namespace App\Services\Dashboard;

use App\Helper\Media;
use App\Models\Team;
use App\Services\JsonTranslationService;
use Illuminate\Support\Facades\DB;

class TeamService
{
    public function store($request)
    {
        $data = $request->validated();
        DB::beginTransaction();
        try {
            // Prepare main data (non-translatable fields)
            $mainData = [
            'facebook' => $data['facebook'] ?? null,
            'twitter' => $data['twitter'] ?? null,
            'instagram' => $data['instagram'] ?? null,
            'tiktok' => $data['tiktok'] ?? null,
            'youtube' => $data['youtube'] ?? null,
            'alt_image' => $data['alt_image'] ?? null,
            'status' => $data['status'] ?? 1,
            'order' => $dat['order'] ?? 0,
        ];

            // Handle file uploads
            if ($request->hasFile('image')) {
                $mainData['image'] = Media::uploadAndAttachImageStorage($request->file('image'), 'teams');
            }

           
            // Get translation fields
            $translationFields = JsonTranslationService::getTranslationFields('team');
            // Create model with JSON translations
            $model = JsonTranslationService::createWithTranslations(Team::class, $mainData, $request, $translationFields);

            DB::commit();

            return $model;

        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }

    }

    public function update($request, $team)
    {
        $data = $request->validated();
        DB::beginTransaction();

        try {
        // Prepare main data (non-translatable fields)
        $mainData = [
            'facebook' => $data['facebook'] ?? $team->facebook,
            'twitter' => $data['twitter'] ?? $team->twitter,
            'instagram' => $data['instagram'] ?? $team->instagram,
            'tiktok' => $data['tiktok'] ?? $team->tiktok,
            'youtube' => $data['youtube'] ?? $team->youtube,
            'alt_image' => $data['alt_image'] ?? $team->alt_image,
            'status' => $data['status'] ?? $team->status,
            'order' => $dat['order'] ?? $team->order,
        ];
            // Handle file uploads
            if ($request->hasFile('image')) {
                if ($team->image) {
                    Media::removeFile('teams', $team->image);
                }
                $mainData['image'] = Media::uploadAndAttachImageStorage($request->file('image'), 'teams');
            }

            // Get translation fields
            $translationFields = JsonTranslationService::getTranslationFields('team');

            // Update model with JSON translations
            JsonTranslationService::updateWithTranslations($team, $mainData, $request, $translationFields);

            DB::commit();
            return $team;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function delete($selectedIds, $data = null)
    {
        DB::beginTransaction();
        try {
            if (is_array($selectedIds)) {
                foreach ($selectedIds as $id) {
                    $slider = Team::find($id);
                    if ($slider) {
                        // Delete images from storage
                        if ($slider->image) {
                            Media::removeFile('sliders', $slider->image);
                        }
                        if ($slider->mobile_image) {
                            Media::removeFile('sliders', $slider->mobile_image);
                        }
                        if ($slider->icon) {
                            Media::removeFile('sliders', $slider->icon);
                        }

                        // Delete the slider
                        $slider->delete();
                    }
                }
            }else {
                $slider = Team::find($selectedIds);
                if ($slider) {
                    
                    if ($slider->image) {
                        Media::removeFile('teams', $slider->image);
                    }

                    if ($slider->mobile_image) {
                        Media::removeFile('teams', $slider->mobile_image);
                    }

                    if ($slider->icon) {
                        Media::removeFile('teams', $slider->icon);
                    }

                    // Delete the slider
                    $slider->delete();
                }
            }

            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }
}
