<?php

namespace App\Services\Dashboard;

use App\Helper\Media;
use App\Services\JsonTranslationService;
use App\Models\Phone;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;


class PhoneService
{
    /**
     * Clean Arabic text for slug usage
     * Keep Arabic characters but remove special characters and spaces
     */
    private function cleanArabicSlug($text)
    {
        // Replace spaces and special characters with dashes, but keep Arabic characters
        $slug = str_replace([' ', '/', '\\', '?', '#', '[', ']', '@', '!', '$', '&', "'", '(', ')', '*', '+', ',', ';', '=', '%'], '-', $text);

        // Remove multiple dashes
        $slug = preg_replace('/-+/', '-', $slug);

        // Remove leading/trailing dashes
        $slug = trim($slug, '-');

        return $slug;
    }

    public function store($request)
    {
        $data = $request->validated();

        DB::beginTransaction();
        try {


            // Prepare main model data
            $mainData = $data;

            // Get translation fields
            $translationFields = JsonTranslationService::getTranslationFields('phone');

            // Create model with JSON translations
            $model = JsonTranslationService::createWithTranslations(Phone::class, $mainData, $request, $translationFields);
           

            DB::commit();
            return $model;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function update($request, $model)
    {
        $data = $request->validated();

        DB::beginTransaction();

        try {
          

            // Prepare main model data
            $mainData = $data;

            // Get translation fields
            $translationFields = JsonTranslationService::getTranslationFields('phone');

            // Update model with JSON translations
            $model = JsonTranslationService::updateWithTranslations($model, $mainData, $request, $translationFields);
            
           
            DB::commit();
            return $model;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function delete($selectedIds)
    {
      

        $phones = Phone::whereIn('id', $selectedIds)->get();

        Log::info('Found phones to delete', [
            'count' => $phones->count(),
            'phones' => $phones->pluck('id')->toArray()
        ]);

        DB::beginTransaction();


        try {
            foreach($phones as $phone){
                $phone->delete();
                Log::info('Deleted phone', [
                    'phone_id' => $phone->id
                ]);
            }
            DB::commit();
            Log::info('Delete operation completed successfully');
            return true;
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Delete operation failed', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            throw $e;
        }
    }

    /**
     * Delete all images associated with a phone
     */
   
}
