<?php

namespace App\Models;

use App\Traits\HasLanguage;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pdf extends Model
{
    /** @use HasFactory<\Database\Factories\ClientFactory> */
    use HasFactory,HasLanguage;
    protected $fillable = [
        'real_name',
        'name',
        'product_id',
        
    ];

    public function getPdfPathAttribute()
    {
        return $this->name ? asset('storage/products/pdf/' . $this->name) : null;
    }

   
}
