<?php

namespace App\Models;

use App\Traits\HasJsonTranslations;
use Illuminate\Database\Eloquent\Model;

class Feature extends Model
{
    use  HasJsonTranslations;
    protected $fillable = [
        'title',
        'text',
        'counter',
        'icon',
        'status',
    ];

    protected $casts = [
        'title' => 'array',
        'text' => 'array',
    ];


    public function getTitleAttribute()
    {
        return $this->getTranslation('title', app()->getLocale());
    }

    public function getTextAttribute()
    {
        return $this->getTranslation('text', app()->getLocale());
    }

    public function getIconPathAttribute()
    {
        return $this->attributes['icon'] ? asset('storage/features/' . $this->attributes['icon']) : asset('assets/dashboard/images/noimage.png');

    }

    public function scopeActive($query)
    {
        return $query->whereStatus(1);
    }
}
